%------------------------------------------------------------------------------
% File     : ITP193^2 : TPTP v9.2.0. Released v7.5.0.
% Domain   : Interactive Theorem Proving
% Problem  : Sledgehammer Sturm_Tarski problem prob_1192__5884460_1
% Version  : Especial.
% English  :

% Refs     : [BH+15] Blanchette et al. (2015), Mining the Archive of Formal
%          : [Des21] Desharnais (2021), Email to Geoff Sutcliffe
% Source   : [Des21]
% Names    : Sturm_Tarski/prob_1192__5884460_1 [Des21]

% Status   : Theorem
% Rating   : 0.00 v8.1.0, 0.25 v7.5.0
% Syntax   : Number of formulae    :  407 ( 108 unt;  55 typ;   0 def)
%            Number of atoms       : 1123 ( 221 equ;   0 cnn)
%            Maximal formula atoms :   13 (   3 avg)
%            Number of connectives : 3733 ( 103   ~;  27   |;  90   &;2937   @)
%                                         (   0 <=>; 576  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   22 (   7 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :  154 ( 154   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   55 (  52 usr;   7 con; 0-4 aty)
%            Number of variables   : 1086 (  94   ^; 900   !;  49   ?;1086   :)
%                                         (  43  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Sledgehammer 2021-02-23 16:29:27.553
%------------------------------------------------------------------------------
% Could-be-implicit typings (5)
thf(ty_t_Polynomial_Opoly,type,
    poly: $tType > $tType ).

thf(ty_t_Real_Oreal,type,
    real: $tType ).

thf(ty_t_Set_Oset,type,
    set: $tType > $tType ).

thf(ty_t_Nat_Onat,type,
    nat: $tType ).

thf(ty_t_Int_Oint,type,
    int: $tType ).

% Explicit typings (50)
thf(sy_cl_Rings_Oidom,type,
    idom: 
      !>[A: $tType] : $o ).

thf(sy_cl_HOL_Otype,type,
    type: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

thf(sy_cl_Nat_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Ono__bot,type,
    no_bot: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Ono__top,type,
    no_top: 
      !>[A: $tType] : $o ).

thf(sy_cl_Finite__Set_Ofinite,type,
    finite_finite: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Ocomm__ring__1,type,
    comm_ring_1: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Owellorder,type,
    wellorder: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Ozero__less__one,type,
    zero_less_one: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Odense__order,type,
    dense_order: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Ocomm__semiring__0,type,
    comm_semiring_0: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Fields_Olinordered__field,type,
    linordered_field: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Odense__linorder,type,
    dense_linorder: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Oring__no__zero__divisors,type,
    ring_n68954251visors: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Oordered__comm__monoid__add,type,
    ordere216010020id_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Olinordered__nonzero__semiring,type,
    linord1659791738miring: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ocanonically__ordered__monoid__add,type,
    canoni770627133id_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Oordered__cancel__comm__monoid__add,type,
    ordere1818651114id_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Conditionally__Complete__Lattices_Olinear__continuum,type,
    condit1656338222tinuum: 
      !>[A: $tType] : $o ).

thf(sy_cl_Conditionally__Complete__Lattices_Oconditionally__complete__linorder,type,
    condit1037483654norder: 
      !>[A: $tType] : $o ).

thf(sy_c_Finite__Set_Ofinite,type,
    finite_finite2: 
      !>[A: $tType] : ( ( set @ A ) > $o ) ).

thf(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

thf(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

thf(sy_c_Groups__Big_Ocomm__monoid__add__class_Osum,type,
    groups1340683514dd_sum: 
      !>[B: $tType,A: $tType] : ( ( B > A ) > ( set @ B ) > A ) ).

thf(sy_c_If,type,
    if: 
      !>[A: $tType] : ( $o > A > A > A ) ).

thf(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Polynomial_Ois__zero,type,
    is_zero: 
      !>[A: $tType] : ( ( poly @ A ) > $o ) ).

thf(sy_c_Polynomial_Opoly,type,
    poly2: 
      !>[A: $tType] : ( ( poly @ A ) > A > A ) ).

thf(sy_c_Polynomial_Opoly__cutoff,type,
    poly_cutoff: 
      !>[A: $tType] : ( nat > ( poly @ A ) > ( poly @ A ) ) ).

thf(sy_c_Polynomial_Oreflect__poly,type,
    reflect_poly: 
      !>[A: $tType] : ( ( poly @ A ) > ( poly @ A ) ) ).

thf(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) ) ).

thf(sy_c_Sturm__Tarski__Mirabelle__osyjafhhev_Ocindex__poly,type,
    sturm_1539314049x_poly: real > real > ( poly @ real ) > ( poly @ real ) > int ).

thf(sy_c_Sturm__Tarski__Mirabelle__osyjafhhev_Ocross,type,
    sturm_424270202_cross: ( poly @ real ) > real > real > int ).

thf(sy_c_Sturm__Tarski__Mirabelle__osyjafhhev_Ojump__poly,type,
    sturm_652470720p_poly: ( poly @ real ) > ( poly @ real ) > real > int ).

thf(sy_c_member,type,
    member: 
      !>[A: $tType] : ( A > ( set @ A ) > $o ) ).

thf(sy_v_a,type,
    a: real ).

thf(sy_v_a_H,type,
    a2: real ).

thf(sy_v_b,type,
    b: real ).

thf(sy_v_b_H,type,
    b2: real ).

thf(sy_v_p,type,
    p: poly @ real ).

% Relevant facts (254)
thf(fact_0__092_060open_062finite_A_123x_O_Apoly_Ap_Ax_A_061_A0_125_092_060close_062,axiom,
    ( finite_finite2 @ real
    @ ( collect @ real
      @ ^ [X: real] :
          ( ( poly2 @ real @ p @ X )
          = ( zero_zero @ real ) ) ) ) ).

% \<open>finite {x. poly p x = 0}\<close>
thf(fact_1_assms_I2_J,axiom,
    ord_less @ real @ a2 @ b2 ).

% assms(2)
thf(fact_2_assms_I3_J,axiom,
    ord_less @ real @ b2 @ b ).

% assms(3)
thf(fact_3_assms_I1_J,axiom,
    ord_less @ real @ a @ a2 ).

% assms(1)
thf(fact_4_False,axiom,
    ( p
   != ( zero_zero @ ( poly @ real ) ) ) ).

% False
thf(fact_5_poly__0,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_0 @ A )
     => ! [X2: A] :
          ( ( poly2 @ A @ ( zero_zero @ ( poly @ A ) ) @ X2 )
          = ( zero_zero @ A ) ) ) ).

% poly_0
thf(fact_6_not__gr__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [N: A] :
          ( ( ~ ( ord_less @ A @ ( zero_zero @ A ) @ N ) )
          = ( N
            = ( zero_zero @ A ) ) ) ) ).

% not_gr_zero
thf(fact_7_assms_I4_J,axiom,
    ! [X3: real] :
      ( ( ( ( ord_less @ real @ a @ X3 )
          & ( ord_less_eq @ real @ X3 @ a2 ) )
        | ( ( ord_less_eq @ real @ b2 @ X3 )
          & ( ord_less @ real @ X3 @ b ) ) )
     => ( ( poly2 @ real @ p @ X3 )
       != ( zero_zero @ real ) ) ) ).

% assms(4)
thf(fact_8_finite__Collect__conjI,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ( ( finite_finite2 @ A @ ( collect @ A @ P ) )
        | ( finite_finite2 @ A @ ( collect @ A @ Q ) ) )
     => ( finite_finite2 @ A
        @ ( collect @ A
          @ ^ [X: A] :
              ( ( P @ X )
              & ( Q @ X ) ) ) ) ) ).

% finite_Collect_conjI
thf(fact_9_finite__Collect__disjI,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ( finite_finite2 @ A
        @ ( collect @ A
          @ ^ [X: A] :
              ( ( P @ X )
              | ( Q @ X ) ) ) )
      = ( ( finite_finite2 @ A @ ( collect @ A @ P ) )
        & ( finite_finite2 @ A @ ( collect @ A @ Q ) ) ) ) ).

% finite_Collect_disjI
thf(fact_10_poly__roots__finite,axiom,
    ! [A: $tType] :
      ( ( ( comm_ring_1 @ A )
        & ( ring_n68954251visors @ A ) )
     => ! [P2: poly @ A] :
          ( ( P2
           != ( zero_zero @ ( poly @ A ) ) )
         => ( finite_finite2 @ A
            @ ( collect @ A
              @ ^ [X: A] :
                  ( ( poly2 @ A @ P2 @ X )
                  = ( zero_zero @ A ) ) ) ) ) ) ).

% poly_roots_finite
thf(fact_11_poly__IVT__neg,axiom,
    ! [A2: real,B2: real,P2: poly @ real] :
      ( ( ord_less @ real @ A2 @ B2 )
     => ( ( ord_less @ real @ ( zero_zero @ real ) @ ( poly2 @ real @ P2 @ A2 ) )
       => ( ( ord_less @ real @ ( poly2 @ real @ P2 @ B2 ) @ ( zero_zero @ real ) )
         => ? [X4: real] :
              ( ( ord_less @ real @ A2 @ X4 )
              & ( ord_less @ real @ X4 @ B2 )
              & ( ( poly2 @ real @ P2 @ X4 )
                = ( zero_zero @ real ) ) ) ) ) ) ).

% poly_IVT_neg
thf(fact_12_poly__IVT__pos,axiom,
    ! [A2: real,B2: real,P2: poly @ real] :
      ( ( ord_less @ real @ A2 @ B2 )
     => ( ( ord_less @ real @ ( poly2 @ real @ P2 @ A2 ) @ ( zero_zero @ real ) )
       => ( ( ord_less @ real @ ( zero_zero @ real ) @ ( poly2 @ real @ P2 @ B2 ) )
         => ? [X4: real] :
              ( ( ord_less @ real @ A2 @ X4 )
              & ( ord_less @ real @ X4 @ B2 )
              & ( ( poly2 @ real @ P2 @ X4 )
                = ( zero_zero @ real ) ) ) ) ) ) ).

% poly_IVT_pos
thf(fact_13_finite__code,axiom,
    ! [A: $tType] :
      ( ( finite_finite @ A )
     => ( ( finite_finite2 @ A )
        = ( ^ [A3: set @ A] : $true ) ) ) ).

% finite_code
thf(fact_14_poly__all__0__iff__0,axiom,
    ! [A: $tType] :
      ( ( ( ring_char_0 @ A )
        & ( comm_ring_1 @ A )
        & ( ring_n68954251visors @ A ) )
     => ! [P2: poly @ A] :
          ( ( ! [X: A] :
                ( ( poly2 @ A @ P2 @ X )
                = ( zero_zero @ A ) ) )
          = ( P2
            = ( zero_zero @ ( poly @ A ) ) ) ) ) ).

% poly_all_0_iff_0
thf(fact_15_less__numeral__extra_I3_J,axiom,
    ! [A: $tType] :
      ( ( linord1659791738miring @ A )
     => ~ ( ord_less @ A @ ( zero_zero @ A ) @ ( zero_zero @ A ) ) ) ).

% less_numeral_extra(3)
thf(fact_16_le__zero__eq,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [N: A] :
          ( ( ord_less_eq @ A @ N @ ( zero_zero @ A ) )
          = ( N
            = ( zero_zero @ A ) ) ) ) ).

% le_zero_eq
thf(fact_17_zero__le,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [X2: A] : ( ord_less_eq @ A @ ( zero_zero @ A ) @ X2 ) ) ).

% zero_le
thf(fact_18_le__numeral__extra_I3_J,axiom,
    ! [A: $tType] :
      ( ( linord1659791738miring @ A )
     => ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( zero_zero @ A ) ) ) ).

% le_numeral_extra(3)
thf(fact_19_finite__psubset__induct,axiom,
    ! [A: $tType,A4: set @ A,P: ( set @ A ) > $o] :
      ( ( finite_finite2 @ A @ A4 )
     => ( ! [A5: set @ A] :
            ( ( finite_finite2 @ A @ A5 )
           => ( ! [B3: set @ A] :
                  ( ( ord_less @ ( set @ A ) @ B3 @ A5 )
                 => ( P @ B3 ) )
             => ( P @ A5 ) ) )
       => ( P @ A4 ) ) ) ).

% finite_psubset_induct
thf(fact_20_finite__has__minimal2,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A4: set @ A,A2: A] :
          ( ( finite_finite2 @ A @ A4 )
         => ( ( member @ A @ A2 @ A4 )
           => ? [X4: A] :
                ( ( member @ A @ X4 @ A4 )
                & ( ord_less_eq @ A @ X4 @ A2 )
                & ! [Xa: A] :
                    ( ( member @ A @ Xa @ A4 )
                   => ( ( ord_less_eq @ A @ Xa @ X4 )
                     => ( X4 = Xa ) ) ) ) ) ) ) ).

% finite_has_minimal2
thf(fact_21_finite__has__maximal2,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A4: set @ A,A2: A] :
          ( ( finite_finite2 @ A @ A4 )
         => ( ( member @ A @ A2 @ A4 )
           => ? [X4: A] :
                ( ( member @ A @ X4 @ A4 )
                & ( ord_less_eq @ A @ A2 @ X4 )
                & ! [Xa: A] :
                    ( ( member @ A @ Xa @ A4 )
                   => ( ( ord_less_eq @ A @ X4 @ Xa )
                     => ( X4 = Xa ) ) ) ) ) ) ) ).

% finite_has_maximal2
thf(fact_22_next__non__root__interval,axiom,
    ! [P2: poly @ real,Lb: real] :
      ( ( P2
       != ( zero_zero @ ( poly @ real ) ) )
     => ~ ! [Ub: real] :
            ( ( ord_less @ real @ Lb @ Ub )
           => ~ ! [Z: real] :
                  ( ( ( ord_less @ real @ Lb @ Z )
                    & ( ord_less_eq @ real @ Z @ Ub ) )
                 => ( ( poly2 @ real @ P2 @ Z )
                   != ( zero_zero @ real ) ) ) ) ) ).

% next_non_root_interval
thf(fact_23_last__non__root__interval,axiom,
    ! [P2: poly @ real,Ub2: real] :
      ( ( P2
       != ( zero_zero @ ( poly @ real ) ) )
     => ~ ! [Lb2: real] :
            ( ( ord_less @ real @ Lb2 @ Ub2 )
           => ~ ! [Z: real] :
                  ( ( ( ord_less_eq @ real @ Lb2 @ Z )
                    & ( ord_less @ real @ Z @ Ub2 ) )
                 => ( ( poly2 @ real @ P2 @ Z )
                   != ( zero_zero @ real ) ) ) ) ) ).

% last_non_root_interval
thf(fact_24_zero__reorient,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [X2: A] :
          ( ( ( zero_zero @ A )
            = X2 )
          = ( X2
            = ( zero_zero @ A ) ) ) ) ).

% zero_reorient
thf(fact_25_finite,axiom,
    ! [A: $tType] :
      ( ( finite_finite @ A )
     => ! [A4: set @ A] : ( finite_finite2 @ A @ A4 ) ) ).

% finite
thf(fact_26_finite__set__choice,axiom,
    ! [B: $tType,A: $tType,A4: set @ A,P: A > B > $o] :
      ( ( finite_finite2 @ A @ A4 )
     => ( ! [X4: A] :
            ( ( member @ A @ X4 @ A4 )
           => ? [X_1: B] : ( P @ X4 @ X_1 ) )
       => ? [F: A > B] :
          ! [X3: A] :
            ( ( member @ A @ X3 @ A4 )
           => ( P @ X3 @ ( F @ X3 ) ) ) ) ) ).

% finite_set_choice
thf(fact_27_not__eq__pos__or__neg__iff__2,axiom,
    ! [Lb: real,Ub2: real,P2: poly @ real] :
      ( ( ! [Z2: real] :
            ( ( ( ord_less_eq @ real @ Lb @ Z2 )
              & ( ord_less @ real @ Z2 @ Ub2 ) )
           => ( ( poly2 @ real @ P2 @ Z2 )
             != ( zero_zero @ real ) ) ) )
      = ( ! [Z2: real] :
            ( ( ( ord_less_eq @ real @ Lb @ Z2 )
              & ( ord_less @ real @ Z2 @ Ub2 ) )
           => ( ord_less @ real @ ( zero_zero @ real ) @ ( poly2 @ real @ P2 @ Z2 ) ) )
        | ! [Z2: real] :
            ( ( ( ord_less_eq @ real @ Lb @ Z2 )
              & ( ord_less @ real @ Z2 @ Ub2 ) )
           => ( ord_less @ real @ ( poly2 @ real @ P2 @ Z2 ) @ ( zero_zero @ real ) ) ) ) ) ).

% not_eq_pos_or_neg_iff_2
thf(fact_28_not__eq__pos__or__neg__iff__1,axiom,
    ! [Lb: real,Ub2: real,P2: poly @ real] :
      ( ( ! [Z2: real] :
            ( ( ( ord_less @ real @ Lb @ Z2 )
              & ( ord_less_eq @ real @ Z2 @ Ub2 ) )
           => ( ( poly2 @ real @ P2 @ Z2 )
             != ( zero_zero @ real ) ) ) )
      = ( ! [Z2: real] :
            ( ( ( ord_less @ real @ Lb @ Z2 )
              & ( ord_less_eq @ real @ Z2 @ Ub2 ) )
           => ( ord_less @ real @ ( zero_zero @ real ) @ ( poly2 @ real @ P2 @ Z2 ) ) )
        | ! [Z2: real] :
            ( ( ( ord_less @ real @ Lb @ Z2 )
              & ( ord_less_eq @ real @ Z2 @ Ub2 ) )
           => ( ord_less @ real @ ( poly2 @ real @ P2 @ Z2 ) @ ( zero_zero @ real ) ) ) ) ) ).

% not_eq_pos_or_neg_iff_1
thf(fact_29_poly__eq__poly__eq__iff,axiom,
    ! [A: $tType] :
      ( ( ( ring_char_0 @ A )
        & ( comm_ring_1 @ A )
        & ( ring_n68954251visors @ A ) )
     => ! [P2: poly @ A,Q2: poly @ A] :
          ( ( ( poly2 @ A @ P2 )
            = ( poly2 @ A @ Q2 ) )
          = ( P2 = Q2 ) ) ) ).

% poly_eq_poly_eq_iff
thf(fact_30_pigeonhole__infinite__rel,axiom,
    ! [B: $tType,A: $tType,A4: set @ A,B4: set @ B,R: A > B > $o] :
      ( ~ ( finite_finite2 @ A @ A4 )
     => ( ( finite_finite2 @ B @ B4 )
       => ( ! [X4: A] :
              ( ( member @ A @ X4 @ A4 )
             => ? [Xa: B] :
                  ( ( member @ B @ Xa @ B4 )
                  & ( R @ X4 @ Xa ) ) )
         => ? [X4: B] :
              ( ( member @ B @ X4 @ B4 )
              & ~ ( finite_finite2 @ A
                  @ ( collect @ A
                    @ ^ [A6: A] :
                        ( ( member @ A @ A6 @ A4 )
                        & ( R @ A6 @ X4 ) ) ) ) ) ) ) ) ).

% pigeonhole_infinite_rel
thf(fact_31_not__finite__existsD,axiom,
    ! [A: $tType,P: A > $o] :
      ( ~ ( finite_finite2 @ A @ ( collect @ A @ P ) )
     => ? [X_12: A] : ( P @ X_12 ) ) ).

% not_finite_existsD
thf(fact_32_zero__less__iff__neq__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [N: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ N )
          = ( N
           != ( zero_zero @ A ) ) ) ) ).

% zero_less_iff_neq_zero
thf(fact_33_gr__implies__not__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [M: A,N: A] :
          ( ( ord_less @ A @ M @ N )
         => ( N
           != ( zero_zero @ A ) ) ) ) ).

% gr_implies_not_zero
thf(fact_34_not__less__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [N: A] :
          ~ ( ord_less @ A @ N @ ( zero_zero @ A ) ) ) ).

% not_less_zero
thf(fact_35_gr__zeroI,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [N: A] :
          ( ( N
           != ( zero_zero @ A ) )
         => ( ord_less @ A @ ( zero_zero @ A ) @ N ) ) ) ).

% gr_zeroI
thf(fact_36_order__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X2: A] : ( ord_less_eq @ A @ X2 @ X2 ) ) ).

% order_refl
thf(fact_37_cross__no__root,axiom,
    ! [A2: real,B2: real,P2: poly @ real] :
      ( ( ord_less @ real @ A2 @ B2 )
     => ( ! [X4: real] :
            ( ( ( ord_less @ real @ A2 @ X4 )
              & ( ord_less @ real @ X4 @ B2 ) )
           => ( ( poly2 @ real @ P2 @ X4 )
             != ( zero_zero @ real ) ) )
       => ( ( sturm_424270202_cross @ P2 @ A2 @ B2 )
          = ( zero_zero @ int ) ) ) ) ).

% cross_no_root
thf(fact_38_less__eq__real__def,axiom,
    ( ( ord_less_eq @ real )
    = ( ^ [X: real,Y: real] :
          ( ( ord_less @ real @ X @ Y )
          | ( X = Y ) ) ) ) ).

% less_eq_real_def
thf(fact_39_complete__interval,axiom,
    ! [A: $tType] :
      ( ( condit1037483654norder @ A )
     => ! [A2: A,B2: A,P: A > $o] :
          ( ( ord_less @ A @ A2 @ B2 )
         => ( ( P @ A2 )
           => ( ~ ( P @ B2 )
             => ? [C: A] :
                  ( ( ord_less_eq @ A @ A2 @ C )
                  & ( ord_less_eq @ A @ C @ B2 )
                  & ! [X3: A] :
                      ( ( ( ord_less_eq @ A @ A2 @ X3 )
                        & ( ord_less @ A @ X3 @ C ) )
                     => ( P @ X3 ) )
                  & ! [D: A] :
                      ( ! [X4: A] :
                          ( ( ( ord_less_eq @ A @ A2 @ X4 )
                            & ( ord_less @ A @ X4 @ D ) )
                         => ( P @ X4 ) )
                     => ( ord_less_eq @ A @ D @ C ) ) ) ) ) ) ) ).

% complete_interval
thf(fact_40_order_Onot__eq__order__implies__strict,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A,B2: A] :
          ( ( A2 != B2 )
         => ( ( ord_less_eq @ A @ A2 @ B2 )
           => ( ord_less @ A @ A2 @ B2 ) ) ) ) ).

% order.not_eq_order_implies_strict
thf(fact_41_dual__order_Ostrict__implies__order,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [B2: A,A2: A] :
          ( ( ord_less @ A @ B2 @ A2 )
         => ( ord_less_eq @ A @ B2 @ A2 ) ) ) ).

% dual_order.strict_implies_order
thf(fact_42_dual__order_Ostrict__iff__order,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ( ( ord_less @ A )
        = ( ^ [B5: A,A6: A] :
              ( ( ord_less_eq @ A @ B5 @ A6 )
              & ( A6 != B5 ) ) ) ) ) ).

% dual_order.strict_iff_order
thf(fact_43_dual__order_Oorder__iff__strict,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ( ( ord_less_eq @ A )
        = ( ^ [B5: A,A6: A] :
              ( ( ord_less @ A @ B5 @ A6 )
              | ( A6 = B5 ) ) ) ) ) ).

% dual_order.order_iff_strict
thf(fact_44_mem__Collect__eq,axiom,
    ! [A: $tType,A2: A,P: A > $o] :
      ( ( member @ A @ A2 @ ( collect @ A @ P ) )
      = ( P @ A2 ) ) ).

% mem_Collect_eq
thf(fact_45_Collect__mem__eq,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ( collect @ A
        @ ^ [X: A] : ( member @ A @ X @ A4 ) )
      = A4 ) ).

% Collect_mem_eq
thf(fact_46_Collect__cong,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X4: A] :
          ( ( P @ X4 )
          = ( Q @ X4 ) )
     => ( ( collect @ A @ P )
        = ( collect @ A @ Q ) ) ) ).

% Collect_cong
thf(fact_47_ext,axiom,
    ! [B: $tType,A: $tType,F2: A > B,G: A > B] :
      ( ! [X4: A] :
          ( ( F2 @ X4 )
          = ( G @ X4 ) )
     => ( F2 = G ) ) ).

% ext
thf(fact_48_order_Ostrict__implies__order,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A,B2: A] :
          ( ( ord_less @ A @ A2 @ B2 )
         => ( ord_less_eq @ A @ A2 @ B2 ) ) ) ).

% order.strict_implies_order
thf(fact_49_dense__le__bounded,axiom,
    ! [A: $tType] :
      ( ( dense_linorder @ A )
     => ! [X2: A,Y2: A,Z3: A] :
          ( ( ord_less @ A @ X2 @ Y2 )
         => ( ! [W: A] :
                ( ( ord_less @ A @ X2 @ W )
               => ( ( ord_less @ A @ W @ Y2 )
                 => ( ord_less_eq @ A @ W @ Z3 ) ) )
           => ( ord_less_eq @ A @ Y2 @ Z3 ) ) ) ) ).

% dense_le_bounded
thf(fact_50_finite__Collect__subsets,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ( finite_finite2 @ A @ A4 )
     => ( finite_finite2 @ ( set @ A )
        @ ( collect @ ( set @ A )
          @ ^ [B6: set @ A] : ( ord_less_eq @ ( set @ A ) @ B6 @ A4 ) ) ) ) ).

% finite_Collect_subsets
thf(fact_51_cross__0,axiom,
    ! [A2: real,B2: real] :
      ( ( sturm_424270202_cross @ ( zero_zero @ ( poly @ real ) ) @ A2 @ B2 )
      = ( zero_zero @ int ) ) ).

% cross_0
thf(fact_52_finite__subset,axiom,
    ! [A: $tType,A4: set @ A,B4: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ B4 )
     => ( ( finite_finite2 @ A @ B4 )
       => ( finite_finite2 @ A @ A4 ) ) ) ).

% finite_subset
thf(fact_53_infinite__super,axiom,
    ! [A: $tType,S: set @ A,T: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ S @ T )
     => ( ~ ( finite_finite2 @ A @ S )
       => ~ ( finite_finite2 @ A @ T ) ) ) ).

% infinite_super
thf(fact_54_rev__finite__subset,axiom,
    ! [A: $tType,B4: set @ A,A4: set @ A] :
      ( ( finite_finite2 @ A @ B4 )
     => ( ( ord_less_eq @ ( set @ A ) @ A4 @ B4 )
       => ( finite_finite2 @ A @ A4 ) ) ) ).

% rev_finite_subset
thf(fact_55_dual__order_Oantisym,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [B2: A,A2: A] :
          ( ( ord_less_eq @ A @ B2 @ A2 )
         => ( ( ord_less_eq @ A @ A2 @ B2 )
           => ( A2 = B2 ) ) ) ) ).

% dual_order.antisym
thf(fact_56_dual__order_Oeq__iff,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ( ( ^ [Y3: A,Z4: A] : ( Y3 = Z4 ) )
        = ( ^ [A6: A,B5: A] :
              ( ( ord_less_eq @ A @ B5 @ A6 )
              & ( ord_less_eq @ A @ A6 @ B5 ) ) ) ) ) ).

% dual_order.eq_iff
thf(fact_57_dual__order_Otrans,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [B2: A,A2: A,C2: A] :
          ( ( ord_less_eq @ A @ B2 @ A2 )
         => ( ( ord_less_eq @ A @ C2 @ B2 )
           => ( ord_less_eq @ A @ C2 @ A2 ) ) ) ) ).

% dual_order.trans
thf(fact_58_linorder__wlog,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [P: A > A > $o,A2: A,B2: A] :
          ( ! [A7: A,B7: A] :
              ( ( ord_less_eq @ A @ A7 @ B7 )
             => ( P @ A7 @ B7 ) )
         => ( ! [A7: A,B7: A] :
                ( ( P @ B7 @ A7 )
               => ( P @ A7 @ B7 ) )
           => ( P @ A2 @ B2 ) ) ) ) ).

% linorder_wlog
thf(fact_59_dual__order_Orefl,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A] : ( ord_less_eq @ A @ A2 @ A2 ) ) ).

% dual_order.refl
thf(fact_60_order__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X2: A,Y2: A,Z3: A] :
          ( ( ord_less_eq @ A @ X2 @ Y2 )
         => ( ( ord_less_eq @ A @ Y2 @ Z3 )
           => ( ord_less_eq @ A @ X2 @ Z3 ) ) ) ) ).

% order_trans
thf(fact_61_order__class_Oorder_Oantisym,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A,B2: A] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ( ord_less_eq @ A @ B2 @ A2 )
           => ( A2 = B2 ) ) ) ) ).

% order_class.order.antisym
thf(fact_62_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [A2: A,B2: A,C2: A] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ( B2 = C2 )
           => ( ord_less_eq @ A @ A2 @ C2 ) ) ) ) ).

% ord_le_eq_trans
thf(fact_63_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [A2: A,B2: A,C2: A] :
          ( ( A2 = B2 )
         => ( ( ord_less_eq @ A @ B2 @ C2 )
           => ( ord_less_eq @ A @ A2 @ C2 ) ) ) ) ).

% ord_eq_le_trans
thf(fact_64_order__class_Oorder_Oeq__iff,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ( ( ^ [Y3: A,Z4: A] : ( Y3 = Z4 ) )
        = ( ^ [A6: A,B5: A] :
              ( ( ord_less_eq @ A @ A6 @ B5 )
              & ( ord_less_eq @ A @ B5 @ A6 ) ) ) ) ) ).

% order_class.order.eq_iff
thf(fact_65_antisym__conv,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [Y2: A,X2: A] :
          ( ( ord_less_eq @ A @ Y2 @ X2 )
         => ( ( ord_less_eq @ A @ X2 @ Y2 )
            = ( X2 = Y2 ) ) ) ) ).

% antisym_conv
thf(fact_66_le__cases3,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X2: A,Y2: A,Z3: A] :
          ( ( ( ord_less_eq @ A @ X2 @ Y2 )
           => ~ ( ord_less_eq @ A @ Y2 @ Z3 ) )
         => ( ( ( ord_less_eq @ A @ Y2 @ X2 )
             => ~ ( ord_less_eq @ A @ X2 @ Z3 ) )
           => ( ( ( ord_less_eq @ A @ X2 @ Z3 )
               => ~ ( ord_less_eq @ A @ Z3 @ Y2 ) )
             => ( ( ( ord_less_eq @ A @ Z3 @ Y2 )
                 => ~ ( ord_less_eq @ A @ Y2 @ X2 ) )
               => ( ( ( ord_less_eq @ A @ Y2 @ Z3 )
                   => ~ ( ord_less_eq @ A @ Z3 @ X2 ) )
                 => ~ ( ( ord_less_eq @ A @ Z3 @ X2 )
                     => ~ ( ord_less_eq @ A @ X2 @ Y2 ) ) ) ) ) ) ) ) ).

% le_cases3
thf(fact_67_order_Otrans,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A,B2: A,C2: A] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ( ord_less_eq @ A @ B2 @ C2 )
           => ( ord_less_eq @ A @ A2 @ C2 ) ) ) ) ).

% order.trans
thf(fact_68_le__cases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X2: A,Y2: A] :
          ( ~ ( ord_less_eq @ A @ X2 @ Y2 )
         => ( ord_less_eq @ A @ Y2 @ X2 ) ) ) ).

% le_cases
thf(fact_69_eq__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X2: A,Y2: A] :
          ( ( X2 = Y2 )
         => ( ord_less_eq @ A @ X2 @ Y2 ) ) ) ).

% eq_refl
thf(fact_70_linear,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X2: A,Y2: A] :
          ( ( ord_less_eq @ A @ X2 @ Y2 )
          | ( ord_less_eq @ A @ Y2 @ X2 ) ) ) ).

% linear
thf(fact_71_antisym,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [X2: A,Y2: A] :
          ( ( ord_less_eq @ A @ X2 @ Y2 )
         => ( ( ord_less_eq @ A @ Y2 @ X2 )
           => ( X2 = Y2 ) ) ) ) ).

% antisym
thf(fact_72_eq__iff,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ( ( ^ [Y3: A,Z4: A] : ( Y3 = Z4 ) )
        = ( ^ [X: A,Y: A] :
              ( ( ord_less_eq @ A @ X @ Y )
              & ( ord_less_eq @ A @ Y @ X ) ) ) ) ) ).

% eq_iff
thf(fact_73_ord__le__eq__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( ord @ B )
        & ( ord @ A ) )
     => ! [A2: A,B2: A,F2: A > B,C2: B] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ( ( F2 @ B2 )
              = C2 )
           => ( ! [X4: A,Y4: A] :
                  ( ( ord_less_eq @ A @ X4 @ Y4 )
                 => ( ord_less_eq @ B @ ( F2 @ X4 ) @ ( F2 @ Y4 ) ) )
             => ( ord_less_eq @ B @ ( F2 @ A2 ) @ C2 ) ) ) ) ) ).

% ord_le_eq_subst
thf(fact_74_ord__eq__le__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( ord @ B )
        & ( ord @ A ) )
     => ! [A2: A,F2: B > A,B2: B,C2: B] :
          ( ( A2
            = ( F2 @ B2 ) )
         => ( ( ord_less_eq @ B @ B2 @ C2 )
           => ( ! [X4: B,Y4: B] :
                  ( ( ord_less_eq @ B @ X4 @ Y4 )
                 => ( ord_less_eq @ A @ ( F2 @ X4 ) @ ( F2 @ Y4 ) ) )
             => ( ord_less_eq @ A @ A2 @ ( F2 @ C2 ) ) ) ) ) ) ).

% ord_eq_le_subst
thf(fact_75_order__subst2,axiom,
    ! [A: $tType,C3: $tType] :
      ( ( ( order @ C3 )
        & ( order @ A ) )
     => ! [A2: A,B2: A,F2: A > C3,C2: C3] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ( ord_less_eq @ C3 @ ( F2 @ B2 ) @ C2 )
           => ( ! [X4: A,Y4: A] :
                  ( ( ord_less_eq @ A @ X4 @ Y4 )
                 => ( ord_less_eq @ C3 @ ( F2 @ X4 ) @ ( F2 @ Y4 ) ) )
             => ( ord_less_eq @ C3 @ ( F2 @ A2 ) @ C2 ) ) ) ) ) ).

% order_subst2
thf(fact_76_order__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( order @ B )
        & ( order @ A ) )
     => ! [A2: A,F2: B > A,B2: B,C2: B] :
          ( ( ord_less_eq @ A @ A2 @ ( F2 @ B2 ) )
         => ( ( ord_less_eq @ B @ B2 @ C2 )
           => ( ! [X4: B,Y4: B] :
                  ( ( ord_less_eq @ B @ X4 @ Y4 )
                 => ( ord_less_eq @ A @ ( F2 @ X4 ) @ ( F2 @ Y4 ) ) )
             => ( ord_less_eq @ A @ A2 @ ( F2 @ C2 ) ) ) ) ) ) ).

% order_subst1
thf(fact_77_le__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B )
     => ( ( ord_less_eq @ ( A > B ) )
        = ( ^ [F3: A > B,G2: A > B] :
            ! [X: A] : ( ord_less_eq @ B @ ( F3 @ X ) @ ( G2 @ X ) ) ) ) ) ).

% le_fun_def
thf(fact_78_le__funI,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B )
     => ! [F2: A > B,G: A > B] :
          ( ! [X4: A] : ( ord_less_eq @ B @ ( F2 @ X4 ) @ ( G @ X4 ) )
         => ( ord_less_eq @ ( A > B ) @ F2 @ G ) ) ) ).

% le_funI
thf(fact_79_le__funE,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B )
     => ! [F2: A > B,G: A > B,X2: A] :
          ( ( ord_less_eq @ ( A > B ) @ F2 @ G )
         => ( ord_less_eq @ B @ ( F2 @ X2 ) @ ( G @ X2 ) ) ) ) ).

% le_funE
thf(fact_80_le__funD,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B )
     => ! [F2: A > B,G: A > B,X2: A] :
          ( ( ord_less_eq @ ( A > B ) @ F2 @ G )
         => ( ord_less_eq @ B @ ( F2 @ X2 ) @ ( G @ X2 ) ) ) ) ).

% le_funD
thf(fact_81_ord__eq__less__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( ord @ B )
        & ( ord @ A ) )
     => ! [A2: A,F2: B > A,B2: B,C2: B] :
          ( ( A2
            = ( F2 @ B2 ) )
         => ( ( ord_less @ B @ B2 @ C2 )
           => ( ! [X4: B,Y4: B] :
                  ( ( ord_less @ B @ X4 @ Y4 )
                 => ( ord_less @ A @ ( F2 @ X4 ) @ ( F2 @ Y4 ) ) )
             => ( ord_less @ A @ A2 @ ( F2 @ C2 ) ) ) ) ) ) ).

% ord_eq_less_subst
thf(fact_82_ord__less__eq__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( ord @ B )
        & ( ord @ A ) )
     => ! [A2: A,B2: A,F2: A > B,C2: B] :
          ( ( ord_less @ A @ A2 @ B2 )
         => ( ( ( F2 @ B2 )
              = C2 )
           => ( ! [X4: A,Y4: A] :
                  ( ( ord_less @ A @ X4 @ Y4 )
                 => ( ord_less @ B @ ( F2 @ X4 ) @ ( F2 @ Y4 ) ) )
             => ( ord_less @ B @ ( F2 @ A2 ) @ C2 ) ) ) ) ) ).

% ord_less_eq_subst
thf(fact_83_order__less__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( order @ B )
        & ( order @ A ) )
     => ! [A2: A,F2: B > A,B2: B,C2: B] :
          ( ( ord_less @ A @ A2 @ ( F2 @ B2 ) )
         => ( ( ord_less @ B @ B2 @ C2 )
           => ( ! [X4: B,Y4: B] :
                  ( ( ord_less @ B @ X4 @ Y4 )
                 => ( ord_less @ A @ ( F2 @ X4 ) @ ( F2 @ Y4 ) ) )
             => ( ord_less @ A @ A2 @ ( F2 @ C2 ) ) ) ) ) ) ).

% order_less_subst1
thf(fact_84_order__less__subst2,axiom,
    ! [A: $tType,C3: $tType] :
      ( ( ( order @ C3 )
        & ( order @ A ) )
     => ! [A2: A,B2: A,F2: A > C3,C2: C3] :
          ( ( ord_less @ A @ A2 @ B2 )
         => ( ( ord_less @ C3 @ ( F2 @ B2 ) @ C2 )
           => ( ! [X4: A,Y4: A] :
                  ( ( ord_less @ A @ X4 @ Y4 )
                 => ( ord_less @ C3 @ ( F2 @ X4 ) @ ( F2 @ Y4 ) ) )
             => ( ord_less @ C3 @ ( F2 @ A2 ) @ C2 ) ) ) ) ) ).

% order_less_subst2
thf(fact_85_lt__ex,axiom,
    ! [A: $tType] :
      ( ( no_bot @ A )
     => ! [X2: A] :
        ? [Y4: A] : ( ord_less @ A @ Y4 @ X2 ) ) ).

% lt_ex
thf(fact_86_gt__ex,axiom,
    ! [A: $tType] :
      ( ( no_top @ A )
     => ! [X2: A] :
        ? [X_12: A] : ( ord_less @ A @ X2 @ X_12 ) ) ).

% gt_ex
thf(fact_87_neqE,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X2: A,Y2: A] :
          ( ( X2 != Y2 )
         => ( ~ ( ord_less @ A @ X2 @ Y2 )
           => ( ord_less @ A @ Y2 @ X2 ) ) ) ) ).

% neqE
thf(fact_88_neq__iff,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X2: A,Y2: A] :
          ( ( X2 != Y2 )
          = ( ( ord_less @ A @ X2 @ Y2 )
            | ( ord_less @ A @ Y2 @ X2 ) ) ) ) ).

% neq_iff
thf(fact_89_order_Oasym,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A,B2: A] :
          ( ( ord_less @ A @ A2 @ B2 )
         => ~ ( ord_less @ A @ B2 @ A2 ) ) ) ).

% order.asym
thf(fact_90_dense,axiom,
    ! [A: $tType] :
      ( ( dense_order @ A )
     => ! [X2: A,Y2: A] :
          ( ( ord_less @ A @ X2 @ Y2 )
         => ? [Z5: A] :
              ( ( ord_less @ A @ X2 @ Z5 )
              & ( ord_less @ A @ Z5 @ Y2 ) ) ) ) ).

% dense
thf(fact_91_less__imp__neq,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [X2: A,Y2: A] :
          ( ( ord_less @ A @ X2 @ Y2 )
         => ( X2 != Y2 ) ) ) ).

% less_imp_neq
thf(fact_92_less__asym,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X2: A,Y2: A] :
          ( ( ord_less @ A @ X2 @ Y2 )
         => ~ ( ord_less @ A @ Y2 @ X2 ) ) ) ).

% less_asym
thf(fact_93_less__asym_H,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [A2: A,B2: A] :
          ( ( ord_less @ A @ A2 @ B2 )
         => ~ ( ord_less @ A @ B2 @ A2 ) ) ) ).

% less_asym'
thf(fact_94_less__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X2: A,Y2: A,Z3: A] :
          ( ( ord_less @ A @ X2 @ Y2 )
         => ( ( ord_less @ A @ Y2 @ Z3 )
           => ( ord_less @ A @ X2 @ Z3 ) ) ) ) ).

% less_trans
thf(fact_95_less__linear,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X2: A,Y2: A] :
          ( ( ord_less @ A @ X2 @ Y2 )
          | ( X2 = Y2 )
          | ( ord_less @ A @ Y2 @ X2 ) ) ) ).

% less_linear
thf(fact_96_less__irrefl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X2: A] :
          ~ ( ord_less @ A @ X2 @ X2 ) ) ).

% less_irrefl
thf(fact_97_ord__eq__less__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [A2: A,B2: A,C2: A] :
          ( ( A2 = B2 )
         => ( ( ord_less @ A @ B2 @ C2 )
           => ( ord_less @ A @ A2 @ C2 ) ) ) ) ).

% ord_eq_less_trans
thf(fact_98_ord__less__eq__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [A2: A,B2: A,C2: A] :
          ( ( ord_less @ A @ A2 @ B2 )
         => ( ( B2 = C2 )
           => ( ord_less @ A @ A2 @ C2 ) ) ) ) ).

% ord_less_eq_trans
thf(fact_99_dual__order_Oasym,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [B2: A,A2: A] :
          ( ( ord_less @ A @ B2 @ A2 )
         => ~ ( ord_less @ A @ A2 @ B2 ) ) ) ).

% dual_order.asym
thf(fact_100_less__imp__not__eq,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [X2: A,Y2: A] :
          ( ( ord_less @ A @ X2 @ Y2 )
         => ( X2 != Y2 ) ) ) ).

% less_imp_not_eq
thf(fact_101_less__not__sym,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X2: A,Y2: A] :
          ( ( ord_less @ A @ X2 @ Y2 )
         => ~ ( ord_less @ A @ Y2 @ X2 ) ) ) ).

% less_not_sym
thf(fact_102_less__induct,axiom,
    ! [A: $tType] :
      ( ( wellorder @ A )
     => ! [P: A > $o,A2: A] :
          ( ! [X4: A] :
              ( ! [Y5: A] :
                  ( ( ord_less @ A @ Y5 @ X4 )
                 => ( P @ Y5 ) )
             => ( P @ X4 ) )
         => ( P @ A2 ) ) ) ).

% less_induct
thf(fact_103_antisym__conv3,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [Y2: A,X2: A] :
          ( ~ ( ord_less @ A @ Y2 @ X2 )
         => ( ( ~ ( ord_less @ A @ X2 @ Y2 ) )
            = ( X2 = Y2 ) ) ) ) ).

% antisym_conv3
thf(fact_104_less__imp__not__eq2,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [X2: A,Y2: A] :
          ( ( ord_less @ A @ X2 @ Y2 )
         => ( Y2 != X2 ) ) ) ).

% less_imp_not_eq2
thf(fact_105_less__imp__triv,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X2: A,Y2: A,P: $o] :
          ( ( ord_less @ A @ X2 @ Y2 )
         => ( ( ord_less @ A @ Y2 @ X2 )
           => P ) ) ) ).

% less_imp_triv
thf(fact_106_linorder__cases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X2: A,Y2: A] :
          ( ~ ( ord_less @ A @ X2 @ Y2 )
         => ( ( X2 != Y2 )
           => ( ord_less @ A @ Y2 @ X2 ) ) ) ) ).

% linorder_cases
thf(fact_107_dual__order_Oirrefl,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A] :
          ~ ( ord_less @ A @ A2 @ A2 ) ) ).

% dual_order.irrefl
thf(fact_108_order_Ostrict__trans,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A,B2: A,C2: A] :
          ( ( ord_less @ A @ A2 @ B2 )
         => ( ( ord_less @ A @ B2 @ C2 )
           => ( ord_less @ A @ A2 @ C2 ) ) ) ) ).

% order.strict_trans
thf(fact_109_less__imp__not__less,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X2: A,Y2: A] :
          ( ( ord_less @ A @ X2 @ Y2 )
         => ~ ( ord_less @ A @ Y2 @ X2 ) ) ) ).

% less_imp_not_less
thf(fact_110_exists__least__iff,axiom,
    ! [A: $tType] :
      ( ( wellorder @ A )
     => ( ( ^ [P3: A > $o] :
            ? [X5: A] : ( P3 @ X5 ) )
        = ( ^ [P4: A > $o] :
            ? [N2: A] :
              ( ( P4 @ N2 )
              & ! [M2: A] :
                  ( ( ord_less @ A @ M2 @ N2 )
                 => ~ ( P4 @ M2 ) ) ) ) ) ) ).

% exists_least_iff
thf(fact_111_linorder__less__wlog,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [P: A > A > $o,A2: A,B2: A] :
          ( ! [A7: A,B7: A] :
              ( ( ord_less @ A @ A7 @ B7 )
             => ( P @ A7 @ B7 ) )
         => ( ! [A7: A] : ( P @ A7 @ A7 )
           => ( ! [A7: A,B7: A] :
                  ( ( P @ B7 @ A7 )
                 => ( P @ A7 @ B7 ) )
             => ( P @ A2 @ B2 ) ) ) ) ) ).

% linorder_less_wlog
thf(fact_112_dual__order_Ostrict__trans,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [B2: A,A2: A,C2: A] :
          ( ( ord_less @ A @ B2 @ A2 )
         => ( ( ord_less @ A @ C2 @ B2 )
           => ( ord_less @ A @ C2 @ A2 ) ) ) ) ).

% dual_order.strict_trans
thf(fact_113_not__less__iff__gr__or__eq,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X2: A,Y2: A] :
          ( ( ~ ( ord_less @ A @ X2 @ Y2 ) )
          = ( ( ord_less @ A @ Y2 @ X2 )
            | ( X2 = Y2 ) ) ) ) ).

% not_less_iff_gr_or_eq
thf(fact_114_order_Ostrict__implies__not__eq,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A,B2: A] :
          ( ( ord_less @ A @ A2 @ B2 )
         => ( A2 != B2 ) ) ) ).

% order.strict_implies_not_eq
thf(fact_115_dual__order_Ostrict__implies__not__eq,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [B2: A,A2: A] :
          ( ( ord_less @ A @ B2 @ A2 )
         => ( A2 != B2 ) ) ) ).

% dual_order.strict_implies_not_eq
thf(fact_116_ex__gt__or__lt,axiom,
    ! [A: $tType] :
      ( ( condit1656338222tinuum @ A )
     => ! [A2: A] :
        ? [B7: A] :
          ( ( ord_less @ A @ A2 @ B7 )
          | ( ord_less @ A @ B7 @ A2 ) ) ) ).

% ex_gt_or_lt
thf(fact_117_complete__real,axiom,
    ! [S: set @ real] :
      ( ? [X3: real] : ( member @ real @ X3 @ S )
     => ( ? [Z: real] :
          ! [X4: real] :
            ( ( member @ real @ X4 @ S )
           => ( ord_less_eq @ real @ X4 @ Z ) )
       => ? [Y4: real] :
            ( ! [X3: real] :
                ( ( member @ real @ X3 @ S )
               => ( ord_less_eq @ real @ X3 @ Y4 ) )
            & ! [Z: real] :
                ( ! [X4: real] :
                    ( ( member @ real @ X4 @ S )
                   => ( ord_less_eq @ real @ X4 @ Z ) )
               => ( ord_less_eq @ real @ Y4 @ Z ) ) ) ) ) ).

% complete_real
thf(fact_118_field__lbound__gt__zero,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [D1: A,D2: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ D1 )
         => ( ( ord_less @ A @ ( zero_zero @ A ) @ D2 )
           => ? [E: A] :
                ( ( ord_less @ A @ ( zero_zero @ A ) @ E )
                & ( ord_less @ A @ E @ D1 )
                & ( ord_less @ A @ E @ D2 ) ) ) ) ) ).

% field_lbound_gt_zero
thf(fact_119_leD,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [Y2: A,X2: A] :
          ( ( ord_less_eq @ A @ Y2 @ X2 )
         => ~ ( ord_less @ A @ X2 @ Y2 ) ) ) ).

% leD
thf(fact_120_leI,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X2: A,Y2: A] :
          ( ~ ( ord_less @ A @ X2 @ Y2 )
         => ( ord_less_eq @ A @ Y2 @ X2 ) ) ) ).

% leI
thf(fact_121_le__less,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ( ( ord_less_eq @ A )
        = ( ^ [X: A,Y: A] :
              ( ( ord_less @ A @ X @ Y )
              | ( X = Y ) ) ) ) ) ).

% le_less
thf(fact_122_less__le,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ( ( ord_less @ A )
        = ( ^ [X: A,Y: A] :
              ( ( ord_less_eq @ A @ X @ Y )
              & ( X != Y ) ) ) ) ) ).

% less_le
thf(fact_123_order__le__less__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( order @ B )
        & ( order @ A ) )
     => ! [A2: A,F2: B > A,B2: B,C2: B] :
          ( ( ord_less_eq @ A @ A2 @ ( F2 @ B2 ) )
         => ( ( ord_less @ B @ B2 @ C2 )
           => ( ! [X4: B,Y4: B] :
                  ( ( ord_less @ B @ X4 @ Y4 )
                 => ( ord_less @ A @ ( F2 @ X4 ) @ ( F2 @ Y4 ) ) )
             => ( ord_less @ A @ A2 @ ( F2 @ C2 ) ) ) ) ) ) ).

% order_le_less_subst1
thf(fact_124_order__le__less__subst2,axiom,
    ! [A: $tType,C3: $tType] :
      ( ( ( order @ C3 )
        & ( order @ A ) )
     => ! [A2: A,B2: A,F2: A > C3,C2: C3] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ( ord_less @ C3 @ ( F2 @ B2 ) @ C2 )
           => ( ! [X4: A,Y4: A] :
                  ( ( ord_less_eq @ A @ X4 @ Y4 )
                 => ( ord_less_eq @ C3 @ ( F2 @ X4 ) @ ( F2 @ Y4 ) ) )
             => ( ord_less @ C3 @ ( F2 @ A2 ) @ C2 ) ) ) ) ) ).

% order_le_less_subst2
thf(fact_125_order__less__le__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( order @ B )
        & ( order @ A ) )
     => ! [A2: A,F2: B > A,B2: B,C2: B] :
          ( ( ord_less @ A @ A2 @ ( F2 @ B2 ) )
         => ( ( ord_less_eq @ B @ B2 @ C2 )
           => ( ! [X4: B,Y4: B] :
                  ( ( ord_less_eq @ B @ X4 @ Y4 )
                 => ( ord_less_eq @ A @ ( F2 @ X4 ) @ ( F2 @ Y4 ) ) )
             => ( ord_less @ A @ A2 @ ( F2 @ C2 ) ) ) ) ) ) ).

% order_less_le_subst1
thf(fact_126_order__less__le__subst2,axiom,
    ! [A: $tType,C3: $tType] :
      ( ( ( order @ C3 )
        & ( order @ A ) )
     => ! [A2: A,B2: A,F2: A > C3,C2: C3] :
          ( ( ord_less @ A @ A2 @ B2 )
         => ( ( ord_less_eq @ C3 @ ( F2 @ B2 ) @ C2 )
           => ( ! [X4: A,Y4: A] :
                  ( ( ord_less @ A @ X4 @ Y4 )
                 => ( ord_less @ C3 @ ( F2 @ X4 ) @ ( F2 @ Y4 ) ) )
             => ( ord_less @ C3 @ ( F2 @ A2 ) @ C2 ) ) ) ) ) ).

% order_less_le_subst2
thf(fact_127_not__le,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X2: A,Y2: A] :
          ( ( ~ ( ord_less_eq @ A @ X2 @ Y2 ) )
          = ( ord_less @ A @ Y2 @ X2 ) ) ) ).

% not_le
thf(fact_128_not__less,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X2: A,Y2: A] :
          ( ( ~ ( ord_less @ A @ X2 @ Y2 ) )
          = ( ord_less_eq @ A @ Y2 @ X2 ) ) ) ).

% not_less
thf(fact_129_le__neq__trans,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A,B2: A] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ( A2 != B2 )
           => ( ord_less @ A @ A2 @ B2 ) ) ) ) ).

% le_neq_trans
thf(fact_130_antisym__conv1,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [X2: A,Y2: A] :
          ( ~ ( ord_less @ A @ X2 @ Y2 )
         => ( ( ord_less_eq @ A @ X2 @ Y2 )
            = ( X2 = Y2 ) ) ) ) ).

% antisym_conv1
thf(fact_131_antisym__conv2,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [X2: A,Y2: A] :
          ( ( ord_less_eq @ A @ X2 @ Y2 )
         => ( ( ~ ( ord_less @ A @ X2 @ Y2 ) )
            = ( X2 = Y2 ) ) ) ) ).

% antisym_conv2
thf(fact_132_less__imp__le,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X2: A,Y2: A] :
          ( ( ord_less @ A @ X2 @ Y2 )
         => ( ord_less_eq @ A @ X2 @ Y2 ) ) ) ).

% less_imp_le
thf(fact_133_le__less__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X2: A,Y2: A,Z3: A] :
          ( ( ord_less_eq @ A @ X2 @ Y2 )
         => ( ( ord_less @ A @ Y2 @ Z3 )
           => ( ord_less @ A @ X2 @ Z3 ) ) ) ) ).

% le_less_trans
thf(fact_134_less__le__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X2: A,Y2: A,Z3: A] :
          ( ( ord_less @ A @ X2 @ Y2 )
         => ( ( ord_less_eq @ A @ Y2 @ Z3 )
           => ( ord_less @ A @ X2 @ Z3 ) ) ) ) ).

% less_le_trans
thf(fact_135_dense__ge,axiom,
    ! [A: $tType] :
      ( ( dense_linorder @ A )
     => ! [Z3: A,Y2: A] :
          ( ! [X4: A] :
              ( ( ord_less @ A @ Z3 @ X4 )
             => ( ord_less_eq @ A @ Y2 @ X4 ) )
         => ( ord_less_eq @ A @ Y2 @ Z3 ) ) ) ).

% dense_ge
thf(fact_136_dense__le,axiom,
    ! [A: $tType] :
      ( ( dense_linorder @ A )
     => ! [Y2: A,Z3: A] :
          ( ! [X4: A] :
              ( ( ord_less @ A @ X4 @ Y2 )
             => ( ord_less_eq @ A @ X4 @ Z3 ) )
         => ( ord_less_eq @ A @ Y2 @ Z3 ) ) ) ).

% dense_le
thf(fact_137_le__less__linear,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X2: A,Y2: A] :
          ( ( ord_less_eq @ A @ X2 @ Y2 )
          | ( ord_less @ A @ Y2 @ X2 ) ) ) ).

% le_less_linear
thf(fact_138_le__imp__less__or__eq,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [X2: A,Y2: A] :
          ( ( ord_less_eq @ A @ X2 @ Y2 )
         => ( ( ord_less @ A @ X2 @ Y2 )
            | ( X2 = Y2 ) ) ) ) ).

% le_imp_less_or_eq
thf(fact_139_less__le__not__le,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ( ( ord_less @ A )
        = ( ^ [X: A,Y: A] :
              ( ( ord_less_eq @ A @ X @ Y )
              & ~ ( ord_less_eq @ A @ Y @ X ) ) ) ) ) ).

% less_le_not_le
thf(fact_140_not__le__imp__less,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [Y2: A,X2: A] :
          ( ~ ( ord_less_eq @ A @ Y2 @ X2 )
         => ( ord_less @ A @ X2 @ Y2 ) ) ) ).

% not_le_imp_less
thf(fact_141_order_Ostrict__trans1,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A,B2: A,C2: A] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ( ord_less @ A @ B2 @ C2 )
           => ( ord_less @ A @ A2 @ C2 ) ) ) ) ).

% order.strict_trans1
thf(fact_142_order_Ostrict__trans2,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A,B2: A,C2: A] :
          ( ( ord_less @ A @ A2 @ B2 )
         => ( ( ord_less_eq @ A @ B2 @ C2 )
           => ( ord_less @ A @ A2 @ C2 ) ) ) ) ).

% order.strict_trans2
thf(fact_143_order_Oorder__iff__strict,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ( ( ord_less_eq @ A )
        = ( ^ [A6: A,B5: A] :
              ( ( ord_less @ A @ A6 @ B5 )
              | ( A6 = B5 ) ) ) ) ) ).

% order.order_iff_strict
thf(fact_144_order_Ostrict__iff__order,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ( ( ord_less @ A )
        = ( ^ [A6: A,B5: A] :
              ( ( ord_less_eq @ A @ A6 @ B5 )
              & ( A6 != B5 ) ) ) ) ) ).

% order.strict_iff_order
thf(fact_145_dual__order_Ostrict__trans1,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [B2: A,A2: A,C2: A] :
          ( ( ord_less_eq @ A @ B2 @ A2 )
         => ( ( ord_less @ A @ C2 @ B2 )
           => ( ord_less @ A @ C2 @ A2 ) ) ) ) ).

% dual_order.strict_trans1
thf(fact_146_dual__order_Ostrict__trans2,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [B2: A,A2: A,C2: A] :
          ( ( ord_less @ A @ B2 @ A2 )
         => ( ( ord_less_eq @ A @ C2 @ B2 )
           => ( ord_less @ A @ C2 @ A2 ) ) ) ) ).

% dual_order.strict_trans2
thf(fact_147_dense__ge__bounded,axiom,
    ! [A: $tType] :
      ( ( dense_linorder @ A )
     => ! [Z3: A,X2: A,Y2: A] :
          ( ( ord_less @ A @ Z3 @ X2 )
         => ( ! [W: A] :
                ( ( ord_less @ A @ Z3 @ W )
               => ( ( ord_less @ A @ W @ X2 )
                 => ( ord_less_eq @ A @ Y2 @ W ) ) )
           => ( ord_less_eq @ A @ Y2 @ Z3 ) ) ) ) ).

% dense_ge_bounded
thf(fact_148_psubsetI,axiom,
    ! [A: $tType,A4: set @ A,B4: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ B4 )
     => ( ( A4 != B4 )
       => ( ord_less @ ( set @ A ) @ A4 @ B4 ) ) ) ).

% psubsetI
thf(fact_149_minf_I8_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [T2: A] :
        ? [Z5: A] :
        ! [X3: A] :
          ( ( ord_less @ A @ X3 @ Z5 )
         => ~ ( ord_less_eq @ A @ T2 @ X3 ) ) ) ).

% minf(8)
thf(fact_150_minf_I6_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [T2: A] :
        ? [Z5: A] :
        ! [X3: A] :
          ( ( ord_less @ A @ X3 @ Z5 )
         => ( ord_less_eq @ A @ X3 @ T2 ) ) ) ).

% minf(6)
thf(fact_151_pinf_I8_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [T2: A] :
        ? [Z5: A] :
        ! [X3: A] :
          ( ( ord_less @ A @ Z5 @ X3 )
         => ( ord_less_eq @ A @ T2 @ X3 ) ) ) ).

% pinf(8)
thf(fact_152_pinf_I6_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [T2: A] :
        ? [Z5: A] :
        ! [X3: A] :
          ( ( ord_less @ A @ Z5 @ X3 )
         => ~ ( ord_less_eq @ A @ X3 @ T2 ) ) ) ).

% pinf(6)
thf(fact_153_verit__comp__simplify1_I3_J,axiom,
    ! [B: $tType] :
      ( ( linorder @ B )
     => ! [B8: B,A8: B] :
          ( ( ~ ( ord_less_eq @ B @ B8 @ A8 ) )
          = ( ord_less @ B @ A8 @ B8 ) ) ) ).

% verit_comp_simplify1(3)
thf(fact_154_is__zero__null,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ( ( is_zero @ A )
        = ( ^ [P5: poly @ A] :
              ( P5
              = ( zero_zero @ ( poly @ A ) ) ) ) ) ) ).

% is_zero_null
thf(fact_155_poly__cutoff__0,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [N: nat] :
          ( ( poly_cutoff @ A @ N @ ( zero_zero @ ( poly @ A ) ) )
          = ( zero_zero @ ( poly @ A ) ) ) ) ).

% poly_cutoff_0
thf(fact_156_subsetI,axiom,
    ! [A: $tType,A4: set @ A,B4: set @ A] :
      ( ! [X4: A] :
          ( ( member @ A @ X4 @ A4 )
         => ( member @ A @ X4 @ B4 ) )
     => ( ord_less_eq @ ( set @ A ) @ A4 @ B4 ) ) ).

% subsetI
thf(fact_157_subset__antisym,axiom,
    ! [A: $tType,A4: set @ A,B4: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ B4 )
     => ( ( ord_less_eq @ ( set @ A ) @ B4 @ A4 )
       => ( A4 = B4 ) ) ) ).

% subset_antisym
thf(fact_158_in__mono,axiom,
    ! [A: $tType,A4: set @ A,B4: set @ A,X2: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ B4 )
     => ( ( member @ A @ X2 @ A4 )
       => ( member @ A @ X2 @ B4 ) ) ) ).

% in_mono
thf(fact_159_subsetD,axiom,
    ! [A: $tType,A4: set @ A,B4: set @ A,C2: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ B4 )
     => ( ( member @ A @ C2 @ A4 )
       => ( member @ A @ C2 @ B4 ) ) ) ).

% subsetD
thf(fact_160_equalityE,axiom,
    ! [A: $tType,A4: set @ A,B4: set @ A] :
      ( ( A4 = B4 )
     => ~ ( ( ord_less_eq @ ( set @ A ) @ A4 @ B4 )
         => ~ ( ord_less_eq @ ( set @ A ) @ B4 @ A4 ) ) ) ).

% equalityE
thf(fact_161_subset__eq,axiom,
    ! [A: $tType] :
      ( ( ord_less_eq @ ( set @ A ) )
      = ( ^ [A3: set @ A,B6: set @ A] :
          ! [X: A] :
            ( ( member @ A @ X @ A3 )
           => ( member @ A @ X @ B6 ) ) ) ) ).

% subset_eq
thf(fact_162_equalityD1,axiom,
    ! [A: $tType,A4: set @ A,B4: set @ A] :
      ( ( A4 = B4 )
     => ( ord_less_eq @ ( set @ A ) @ A4 @ B4 ) ) ).

% equalityD1
thf(fact_163_equalityD2,axiom,
    ! [A: $tType,A4: set @ A,B4: set @ A] :
      ( ( A4 = B4 )
     => ( ord_less_eq @ ( set @ A ) @ B4 @ A4 ) ) ).

% equalityD2
thf(fact_164_subset__iff,axiom,
    ! [A: $tType] :
      ( ( ord_less_eq @ ( set @ A ) )
      = ( ^ [A3: set @ A,B6: set @ A] :
          ! [T3: A] :
            ( ( member @ A @ T3 @ A3 )
           => ( member @ A @ T3 @ B6 ) ) ) ) ).

% subset_iff
thf(fact_165_subset__refl,axiom,
    ! [A: $tType,A4: set @ A] : ( ord_less_eq @ ( set @ A ) @ A4 @ A4 ) ).

% subset_refl
thf(fact_166_Collect__mono,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X4: A] :
          ( ( P @ X4 )
         => ( Q @ X4 ) )
     => ( ord_less_eq @ ( set @ A ) @ ( collect @ A @ P ) @ ( collect @ A @ Q ) ) ) ).

% Collect_mono
thf(fact_167_subset__trans,axiom,
    ! [A: $tType,A4: set @ A,B4: set @ A,C4: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ B4 )
     => ( ( ord_less_eq @ ( set @ A ) @ B4 @ C4 )
       => ( ord_less_eq @ ( set @ A ) @ A4 @ C4 ) ) ) ).

% subset_trans
thf(fact_168_set__eq__subset,axiom,
    ! [A: $tType] :
      ( ( ^ [Y3: set @ A,Z4: set @ A] : ( Y3 = Z4 ) )
      = ( ^ [A3: set @ A,B6: set @ A] :
            ( ( ord_less_eq @ ( set @ A ) @ A3 @ B6 )
            & ( ord_less_eq @ ( set @ A ) @ B6 @ A3 ) ) ) ) ).

% set_eq_subset
thf(fact_169_Collect__subset,axiom,
    ! [A: $tType,A4: set @ A,P: A > $o] :
      ( ord_less_eq @ ( set @ A )
      @ ( collect @ A
        @ ^ [X: A] :
            ( ( member @ A @ X @ A4 )
            & ( P @ X ) ) )
      @ A4 ) ).

% Collect_subset
thf(fact_170_less__eq__set__def,axiom,
    ! [A: $tType] :
      ( ( ord_less_eq @ ( set @ A ) )
      = ( ^ [A3: set @ A,B6: set @ A] :
            ( ord_less_eq @ ( A > $o )
            @ ^ [X: A] : ( member @ A @ X @ A3 )
            @ ^ [X: A] : ( member @ A @ X @ B6 ) ) ) ) ).

% less_eq_set_def
thf(fact_171_Collect__mono__iff,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ( ord_less_eq @ ( set @ A ) @ ( collect @ A @ P ) @ ( collect @ A @ Q ) )
      = ( ! [X: A] :
            ( ( P @ X )
           => ( Q @ X ) ) ) ) ).

% Collect_mono_iff
thf(fact_172_less__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B )
     => ( ( ord_less @ ( A > B ) )
        = ( ^ [F3: A > B,G2: A > B] :
              ( ( ord_less_eq @ ( A > B ) @ F3 @ G2 )
              & ~ ( ord_less_eq @ ( A > B ) @ G2 @ F3 ) ) ) ) ) ).

% less_fun_def
thf(fact_173_verit__la__disequality,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [A2: A,B2: A] :
          ( ( A2 = B2 )
          | ~ ( ord_less_eq @ A @ A2 @ B2 )
          | ~ ( ord_less_eq @ A @ B2 @ A2 ) ) ) ).

% verit_la_disequality
thf(fact_174_verit__comp__simplify1_I1_J,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A] :
          ~ ( ord_less @ A @ A2 @ A2 ) ) ).

% verit_comp_simplify1(1)
thf(fact_175_pinf_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [P: A > $o,P6: A > $o,Q: A > $o,Q3: A > $o] :
          ( ? [Z: A] :
            ! [X4: A] :
              ( ( ord_less @ A @ Z @ X4 )
             => ( ( P @ X4 )
                = ( P6 @ X4 ) ) )
         => ( ? [Z: A] :
              ! [X4: A] :
                ( ( ord_less @ A @ Z @ X4 )
               => ( ( Q @ X4 )
                  = ( Q3 @ X4 ) ) )
           => ? [Z5: A] :
              ! [X3: A] :
                ( ( ord_less @ A @ Z5 @ X3 )
               => ( ( ( P @ X3 )
                    & ( Q @ X3 ) )
                  = ( ( P6 @ X3 )
                    & ( Q3 @ X3 ) ) ) ) ) ) ) ).

% pinf(1)
thf(fact_176_pinf_I2_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [P: A > $o,P6: A > $o,Q: A > $o,Q3: A > $o] :
          ( ? [Z: A] :
            ! [X4: A] :
              ( ( ord_less @ A @ Z @ X4 )
             => ( ( P @ X4 )
                = ( P6 @ X4 ) ) )
         => ( ? [Z: A] :
              ! [X4: A] :
                ( ( ord_less @ A @ Z @ X4 )
               => ( ( Q @ X4 )
                  = ( Q3 @ X4 ) ) )
           => ? [Z5: A] :
              ! [X3: A] :
                ( ( ord_less @ A @ Z5 @ X3 )
               => ( ( ( P @ X3 )
                    | ( Q @ X3 ) )
                  = ( ( P6 @ X3 )
                    | ( Q3 @ X3 ) ) ) ) ) ) ) ).

% pinf(2)
thf(fact_177_pinf_I3_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [T2: A] :
        ? [Z5: A] :
        ! [X3: A] :
          ( ( ord_less @ A @ Z5 @ X3 )
         => ( X3 != T2 ) ) ) ).

% pinf(3)
thf(fact_178_pinf_I4_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [T2: A] :
        ? [Z5: A] :
        ! [X3: A] :
          ( ( ord_less @ A @ Z5 @ X3 )
         => ( X3 != T2 ) ) ) ).

% pinf(4)
thf(fact_179_pinf_I5_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [T2: A] :
        ? [Z5: A] :
        ! [X3: A] :
          ( ( ord_less @ A @ Z5 @ X3 )
         => ~ ( ord_less @ A @ X3 @ T2 ) ) ) ).

% pinf(5)
thf(fact_180_pinf_I7_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [T2: A] :
        ? [Z5: A] :
        ! [X3: A] :
          ( ( ord_less @ A @ Z5 @ X3 )
         => ( ord_less @ A @ T2 @ X3 ) ) ) ).

% pinf(7)
thf(fact_181_pinf_I11_J,axiom,
    ! [C3: $tType,D3: $tType] :
      ( ( ord @ C3 )
     => ! [F4: D3] :
        ? [Z5: C3] :
        ! [X3: C3] :
          ( ( ord_less @ C3 @ Z5 @ X3 )
         => ( F4 = F4 ) ) ) ).

% pinf(11)
thf(fact_182_minf_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [P: A > $o,P6: A > $o,Q: A > $o,Q3: A > $o] :
          ( ? [Z: A] :
            ! [X4: A] :
              ( ( ord_less @ A @ X4 @ Z )
             => ( ( P @ X4 )
                = ( P6 @ X4 ) ) )
         => ( ? [Z: A] :
              ! [X4: A] :
                ( ( ord_less @ A @ X4 @ Z )
               => ( ( Q @ X4 )
                  = ( Q3 @ X4 ) ) )
           => ? [Z5: A] :
              ! [X3: A] :
                ( ( ord_less @ A @ X3 @ Z5 )
               => ( ( ( P @ X3 )
                    & ( Q @ X3 ) )
                  = ( ( P6 @ X3 )
                    & ( Q3 @ X3 ) ) ) ) ) ) ) ).

% minf(1)
thf(fact_183_minf_I2_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [P: A > $o,P6: A > $o,Q: A > $o,Q3: A > $o] :
          ( ? [Z: A] :
            ! [X4: A] :
              ( ( ord_less @ A @ X4 @ Z )
             => ( ( P @ X4 )
                = ( P6 @ X4 ) ) )
         => ( ? [Z: A] :
              ! [X4: A] :
                ( ( ord_less @ A @ X4 @ Z )
               => ( ( Q @ X4 )
                  = ( Q3 @ X4 ) ) )
           => ? [Z5: A] :
              ! [X3: A] :
                ( ( ord_less @ A @ X3 @ Z5 )
               => ( ( ( P @ X3 )
                    | ( Q @ X3 ) )
                  = ( ( P6 @ X3 )
                    | ( Q3 @ X3 ) ) ) ) ) ) ) ).

% minf(2)
thf(fact_184_minf_I3_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [T2: A] :
        ? [Z5: A] :
        ! [X3: A] :
          ( ( ord_less @ A @ X3 @ Z5 )
         => ( X3 != T2 ) ) ) ).

% minf(3)
thf(fact_185_minf_I4_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [T2: A] :
        ? [Z5: A] :
        ! [X3: A] :
          ( ( ord_less @ A @ X3 @ Z5 )
         => ( X3 != T2 ) ) ) ).

% minf(4)
thf(fact_186_minf_I5_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [T2: A] :
        ? [Z5: A] :
        ! [X3: A] :
          ( ( ord_less @ A @ X3 @ Z5 )
         => ( ord_less @ A @ X3 @ T2 ) ) ) ).

% minf(5)
thf(fact_187_minf_I7_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [T2: A] :
        ? [Z5: A] :
        ! [X3: A] :
          ( ( ord_less @ A @ X3 @ Z5 )
         => ~ ( ord_less @ A @ T2 @ X3 ) ) ) ).

% minf(7)
thf(fact_188_minf_I11_J,axiom,
    ! [C3: $tType,D3: $tType] :
      ( ( ord @ C3 )
     => ! [F4: D3] :
        ? [Z5: C3] :
        ! [X3: C3] :
          ( ( ord_less @ C3 @ X3 @ Z5 )
         => ( F4 = F4 ) ) ) ).

% minf(11)
thf(fact_189_conj__le__cong,axiom,
    ! [X2: int,X6: int,P: $o,P6: $o] :
      ( ( X2 = X6 )
     => ( ( ( ord_less_eq @ int @ ( zero_zero @ int ) @ X6 )
         => ( P = P6 ) )
       => ( ( ( ord_less_eq @ int @ ( zero_zero @ int ) @ X2 )
            & P )
          = ( ( ord_less_eq @ int @ ( zero_zero @ int ) @ X6 )
            & P6 ) ) ) ) ).

% conj_le_cong
thf(fact_190_imp__le__cong,axiom,
    ! [X2: int,X6: int,P: $o,P6: $o] :
      ( ( X2 = X6 )
     => ( ( ( ord_less_eq @ int @ ( zero_zero @ int ) @ X6 )
         => ( P = P6 ) )
       => ( ( ( ord_less_eq @ int @ ( zero_zero @ int ) @ X2 )
           => P )
          = ( ( ord_less_eq @ int @ ( zero_zero @ int ) @ X6 )
           => P6 ) ) ) ) ).

% imp_le_cong
thf(fact_191_subset__iff__psubset__eq,axiom,
    ! [A: $tType] :
      ( ( ord_less_eq @ ( set @ A ) )
      = ( ^ [A3: set @ A,B6: set @ A] :
            ( ( ord_less @ ( set @ A ) @ A3 @ B6 )
            | ( A3 = B6 ) ) ) ) ).

% subset_iff_psubset_eq
thf(fact_192_subset__psubset__trans,axiom,
    ! [A: $tType,A4: set @ A,B4: set @ A,C4: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ B4 )
     => ( ( ord_less @ ( set @ A ) @ B4 @ C4 )
       => ( ord_less @ ( set @ A ) @ A4 @ C4 ) ) ) ).

% subset_psubset_trans
thf(fact_193_subset__not__subset__eq,axiom,
    ! [A: $tType] :
      ( ( ord_less @ ( set @ A ) )
      = ( ^ [A3: set @ A,B6: set @ A] :
            ( ( ord_less_eq @ ( set @ A ) @ A3 @ B6 )
            & ~ ( ord_less_eq @ ( set @ A ) @ B6 @ A3 ) ) ) ) ).

% subset_not_subset_eq
thf(fact_194_psubset__subset__trans,axiom,
    ! [A: $tType,A4: set @ A,B4: set @ A,C4: set @ A] :
      ( ( ord_less @ ( set @ A ) @ A4 @ B4 )
     => ( ( ord_less_eq @ ( set @ A ) @ B4 @ C4 )
       => ( ord_less @ ( set @ A ) @ A4 @ C4 ) ) ) ).

% psubset_subset_trans
thf(fact_195_psubset__imp__subset,axiom,
    ! [A: $tType,A4: set @ A,B4: set @ A] :
      ( ( ord_less @ ( set @ A ) @ A4 @ B4 )
     => ( ord_less_eq @ ( set @ A ) @ A4 @ B4 ) ) ).

% psubset_imp_subset
thf(fact_196_psubset__trans,axiom,
    ! [A: $tType,A4: set @ A,B4: set @ A,C4: set @ A] :
      ( ( ord_less @ ( set @ A ) @ A4 @ B4 )
     => ( ( ord_less @ ( set @ A ) @ B4 @ C4 )
       => ( ord_less @ ( set @ A ) @ A4 @ C4 ) ) ) ).

% psubset_trans
thf(fact_197_psubset__eq,axiom,
    ! [A: $tType] :
      ( ( ord_less @ ( set @ A ) )
      = ( ^ [A3: set @ A,B6: set @ A] :
            ( ( ord_less_eq @ ( set @ A ) @ A3 @ B6 )
            & ( A3 != B6 ) ) ) ) ).

% psubset_eq
thf(fact_198_psubsetE,axiom,
    ! [A: $tType,A4: set @ A,B4: set @ A] :
      ( ( ord_less @ ( set @ A ) @ A4 @ B4 )
     => ~ ( ( ord_less_eq @ ( set @ A ) @ A4 @ B4 )
         => ( ord_less_eq @ ( set @ A ) @ B4 @ A4 ) ) ) ).

% psubsetE
thf(fact_199_psubsetD,axiom,
    ! [A: $tType,A4: set @ A,B4: set @ A,C2: A] :
      ( ( ord_less @ ( set @ A ) @ A4 @ B4 )
     => ( ( member @ A @ C2 @ A4 )
       => ( member @ A @ C2 @ B4 ) ) ) ).

% psubsetD
thf(fact_200_less__set__def,axiom,
    ! [A: $tType] :
      ( ( ord_less @ ( set @ A ) )
      = ( ^ [A3: set @ A,B6: set @ A] :
            ( ord_less @ ( A > $o )
            @ ^ [X: A] : ( member @ A @ X @ A3 )
            @ ^ [X: A] : ( member @ A @ X @ B6 ) ) ) ) ).

% less_set_def
thf(fact_201_reflect__poly__at__0__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_0 @ A )
     => ! [P2: poly @ A] :
          ( ( ( poly2 @ A @ ( reflect_poly @ A @ P2 ) @ ( zero_zero @ A ) )
            = ( zero_zero @ A ) )
          = ( P2
            = ( zero_zero @ ( poly @ A ) ) ) ) ) ).

% reflect_poly_at_0_eq_0_iff
thf(fact_202_jump__poly__not__root,axiom,
    ! [P2: poly @ real,X2: real,Q2: poly @ real] :
      ( ( ( poly2 @ real @ P2 @ X2 )
       != ( zero_zero @ real ) )
     => ( ( sturm_652470720p_poly @ Q2 @ P2 @ X2 )
        = ( zero_zero @ int ) ) ) ).

% jump_poly_not_root
thf(fact_203_jump__poly0_I2_J,axiom,
    ! [Q2: poly @ real,X2: real] :
      ( ( sturm_652470720p_poly @ Q2 @ ( zero_zero @ ( poly @ real ) ) @ X2 )
      = ( zero_zero @ int ) ) ).

% jump_poly0(2)
thf(fact_204_predicate1I,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X4: A] :
          ( ( P @ X4 )
         => ( Q @ X4 ) )
     => ( ord_less_eq @ ( A > $o ) @ P @ Q ) ) ).

% predicate1I
thf(fact_205_reflect__poly__0,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ( ( reflect_poly @ A @ ( zero_zero @ ( poly @ A ) ) )
        = ( zero_zero @ ( poly @ A ) ) ) ) ).

% reflect_poly_0
thf(fact_206_jump__poly0_I1_J,axiom,
    ! [P2: poly @ real,X2: real] :
      ( ( sturm_652470720p_poly @ ( zero_zero @ ( poly @ real ) ) @ P2 @ X2 )
      = ( zero_zero @ int ) ) ).

% jump_poly0(1)
thf(fact_207_verit__la__generic,axiom,
    ! [A2: int,X2: int] :
      ( ( ord_less_eq @ int @ A2 @ X2 )
      | ( A2 = X2 )
      | ( ord_less_eq @ int @ X2 @ A2 ) ) ).

% verit_la_generic
thf(fact_208_predicate1D,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o,X2: A] :
      ( ( ord_less_eq @ ( A > $o ) @ P @ Q )
     => ( ( P @ X2 )
       => ( Q @ X2 ) ) ) ).

% predicate1D
thf(fact_209_rev__predicate1D,axiom,
    ! [A: $tType,P: A > $o,X2: A,Q: A > $o] :
      ( ( P @ X2 )
     => ( ( ord_less_eq @ ( A > $o ) @ P @ Q )
       => ( Q @ X2 ) ) ) ).

% rev_predicate1D
thf(fact_210_finite__interval__int1,axiom,
    ! [A2: int,B2: int] :
      ( finite_finite2 @ int
      @ ( collect @ int
        @ ^ [I: int] :
            ( ( ord_less_eq @ int @ A2 @ I )
            & ( ord_less_eq @ int @ I @ B2 ) ) ) ) ).

% finite_interval_int1
thf(fact_211_finite__interval__int2,axiom,
    ! [A2: int,B2: int] :
      ( finite_finite2 @ int
      @ ( collect @ int
        @ ^ [I: int] :
            ( ( ord_less_eq @ int @ A2 @ I )
            & ( ord_less @ int @ I @ B2 ) ) ) ) ).

% finite_interval_int2
thf(fact_212_finite__interval__int4,axiom,
    ! [A2: int,B2: int] :
      ( finite_finite2 @ int
      @ ( collect @ int
        @ ^ [I: int] :
            ( ( ord_less @ int @ A2 @ I )
            & ( ord_less @ int @ I @ B2 ) ) ) ) ).

% finite_interval_int4
thf(fact_213_finite__interval__int3,axiom,
    ! [A2: int,B2: int] :
      ( finite_finite2 @ int
      @ ( collect @ int
        @ ^ [I: int] :
            ( ( ord_less @ int @ A2 @ I )
            & ( ord_less_eq @ int @ I @ B2 ) ) ) ) ).

% finite_interval_int3
thf(fact_214_less__int__code_I1_J,axiom,
    ~ ( ord_less @ int @ ( zero_zero @ int ) @ ( zero_zero @ int ) ) ).

% less_int_code(1)
thf(fact_215_less__eq__int__code_I1_J,axiom,
    ord_less_eq @ int @ ( zero_zero @ int ) @ ( zero_zero @ int ) ).

% less_eq_int_code(1)
thf(fact_216_pred__subset__eq,axiom,
    ! [A: $tType,R: set @ A,S: set @ A] :
      ( ( ord_less_eq @ ( A > $o )
        @ ^ [X: A] : ( member @ A @ X @ R )
        @ ^ [X: A] : ( member @ A @ X @ S ) )
      = ( ord_less_eq @ ( set @ A ) @ R @ S ) ) ).

% pred_subset_eq
thf(fact_217_cindex__poly__0_I2_J,axiom,
    ! [A2: real,B2: real,Q2: poly @ real] :
      ( ( sturm_1539314049x_poly @ A2 @ B2 @ Q2 @ ( zero_zero @ ( poly @ real ) ) )
      = ( zero_zero @ int ) ) ).

% cindex_poly_0(2)
thf(fact_218_cindex__poly__0_I1_J,axiom,
    ! [A2: real,B2: real,P2: poly @ real] :
      ( ( sturm_1539314049x_poly @ A2 @ B2 @ ( zero_zero @ ( poly @ real ) ) @ P2 )
      = ( zero_zero @ int ) ) ).

% cindex_poly_0(1)
thf(fact_219_cindex__poly__cross,axiom,
    ! [A2: real,B2: real,P2: poly @ real] :
      ( ( ord_less @ real @ A2 @ B2 )
     => ( ( ( poly2 @ real @ P2 @ A2 )
         != ( zero_zero @ real ) )
       => ( ( ( poly2 @ real @ P2 @ B2 )
           != ( zero_zero @ real ) )
         => ( ( sturm_1539314049x_poly @ A2 @ B2 @ ( one_one @ ( poly @ real ) ) @ P2 )
            = ( sturm_424270202_cross @ P2 @ A2 @ B2 ) ) ) ) ) ).

% cindex_poly_cross
thf(fact_220_cindex__poly__def,axiom,
    ( sturm_1539314049x_poly
    = ( ^ [A6: real,B5: real,Q4: poly @ real,P5: poly @ real] :
          ( groups1340683514dd_sum @ real @ int @ ( sturm_652470720p_poly @ Q4 @ P5 )
          @ ( collect @ real
            @ ^ [X: real] :
                ( ( ( poly2 @ real @ P5 @ X )
                  = ( zero_zero @ real ) )
                & ( ord_less @ real @ A6 @ X )
                & ( ord_less @ real @ X @ B5 ) ) ) ) ) ) ).

% cindex_poly_def
thf(fact_221_reflect__poly__1,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A )
     => ( ( reflect_poly @ A @ ( one_one @ ( poly @ A ) ) )
        = ( one_one @ ( poly @ A ) ) ) ) ).

% reflect_poly_1
thf(fact_222_poly__1,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A )
     => ! [X2: A] :
          ( ( poly2 @ A @ ( one_one @ ( poly @ A ) ) @ X2 )
          = ( one_one @ A ) ) ) ).

% poly_1
thf(fact_223_poly__cutoff__1,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A )
     => ! [N: nat] :
          ( ( ( N
              = ( zero_zero @ nat ) )
           => ( ( poly_cutoff @ A @ N @ ( one_one @ ( poly @ A ) ) )
              = ( zero_zero @ ( poly @ A ) ) ) )
          & ( ( N
             != ( zero_zero @ nat ) )
           => ( ( poly_cutoff @ A @ N @ ( one_one @ ( poly @ A ) ) )
              = ( one_one @ ( poly @ A ) ) ) ) ) ) ).

% poly_cutoff_1
thf(fact_224_le__numeral__extra_I4_J,axiom,
    ! [A: $tType] :
      ( ( linord1659791738miring @ A )
     => ( ord_less_eq @ A @ ( one_one @ A ) @ ( one_one @ A ) ) ) ).

% le_numeral_extra(4)
thf(fact_225_poly__sum,axiom,
    ! [A: $tType,B: $tType] :
      ( ( comm_semiring_0 @ A )
     => ! [P2: B > ( poly @ A ),A4: set @ B,X2: A] :
          ( ( poly2 @ A @ ( groups1340683514dd_sum @ B @ ( poly @ A ) @ P2 @ A4 ) @ X2 )
          = ( groups1340683514dd_sum @ B @ A
            @ ^ [K: B] : ( poly2 @ A @ ( P2 @ K ) @ X2 )
            @ A4 ) ) ) ).

% poly_sum
thf(fact_226_one__reorient,axiom,
    ! [A: $tType] :
      ( ( one @ A )
     => ! [X2: A] :
          ( ( ( one_one @ A )
            = X2 )
          = ( X2
            = ( one_one @ A ) ) ) ) ).

% one_reorient
thf(fact_227_less__numeral__extra_I1_J,axiom,
    ! [A: $tType] :
      ( ( linord1659791738miring @ A )
     => ( ord_less @ A @ ( zero_zero @ A ) @ ( one_one @ A ) ) ) ).

% less_numeral_extra(1)
thf(fact_228_less__numeral__extra_I4_J,axiom,
    ! [A: $tType] :
      ( ( linord1659791738miring @ A )
     => ~ ( ord_less @ A @ ( one_one @ A ) @ ( one_one @ A ) ) ) ).

% less_numeral_extra(4)
thf(fact_229_sum_Odelta_H,axiom,
    ! [B: $tType,A: $tType] :
      ( ( comm_monoid_add @ A )
     => ! [S: set @ B,A2: B,B2: B > A] :
          ( ( finite_finite2 @ B @ S )
         => ( ( ( member @ B @ A2 @ S )
             => ( ( groups1340683514dd_sum @ B @ A
                  @ ^ [K: B] : ( if @ A @ ( A2 = K ) @ ( B2 @ K ) @ ( zero_zero @ A ) )
                  @ S )
                = ( B2 @ A2 ) ) )
            & ( ~ ( member @ B @ A2 @ S )
             => ( ( groups1340683514dd_sum @ B @ A
                  @ ^ [K: B] : ( if @ A @ ( A2 = K ) @ ( B2 @ K ) @ ( zero_zero @ A ) )
                  @ S )
                = ( zero_zero @ A ) ) ) ) ) ) ).

% sum.delta'
thf(fact_230_sum_Odelta,axiom,
    ! [B: $tType,A: $tType] :
      ( ( comm_monoid_add @ A )
     => ! [S: set @ B,A2: B,B2: B > A] :
          ( ( finite_finite2 @ B @ S )
         => ( ( ( member @ B @ A2 @ S )
             => ( ( groups1340683514dd_sum @ B @ A
                  @ ^ [K: B] : ( if @ A @ ( K = A2 ) @ ( B2 @ K ) @ ( zero_zero @ A ) )
                  @ S )
                = ( B2 @ A2 ) ) )
            & ( ~ ( member @ B @ A2 @ S )
             => ( ( groups1340683514dd_sum @ B @ A
                  @ ^ [K: B] : ( if @ A @ ( K = A2 ) @ ( B2 @ K ) @ ( zero_zero @ A ) )
                  @ S )
                = ( zero_zero @ A ) ) ) ) ) ) ).

% sum.delta
thf(fact_231_sum_Oneutral__const,axiom,
    ! [B: $tType,A: $tType] :
      ( ( comm_monoid_add @ A )
     => ! [A4: set @ B] :
          ( ( groups1340683514dd_sum @ B @ A
            @ ^ [Uu: B] : ( zero_zero @ A )
            @ A4 )
          = ( zero_zero @ A ) ) ) ).

% sum.neutral_const
thf(fact_232_sum_Oinfinite,axiom,
    ! [B: $tType,A: $tType] :
      ( ( comm_monoid_add @ A )
     => ! [A4: set @ B,G: B > A] :
          ( ~ ( finite_finite2 @ B @ A4 )
         => ( ( groups1340683514dd_sum @ B @ A @ G @ A4 )
            = ( zero_zero @ A ) ) ) ) ).

% sum.infinite
thf(fact_233_sum__eq__0__iff,axiom,
    ! [A: $tType,B: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [F4: set @ B,F2: B > A] :
          ( ( finite_finite2 @ B @ F4 )
         => ( ( ( groups1340683514dd_sum @ B @ A @ F2 @ F4 )
              = ( zero_zero @ A ) )
            = ( ! [X: B] :
                  ( ( member @ B @ X @ F4 )
                 => ( ( F2 @ X )
                    = ( zero_zero @ A ) ) ) ) ) ) ) ).

% sum_eq_0_iff
thf(fact_234_sum__eq__1__iff,axiom,
    ! [A: $tType,A4: set @ A,F2: A > nat] :
      ( ( finite_finite2 @ A @ A4 )
     => ( ( ( groups1340683514dd_sum @ A @ nat @ F2 @ A4 )
          = ( one_one @ nat ) )
        = ( ? [X: A] :
              ( ( member @ A @ X @ A4 )
              & ( ( F2 @ X )
                = ( one_one @ nat ) )
              & ! [Y: A] :
                  ( ( member @ A @ Y @ A4 )
                 => ( ( X != Y )
                   => ( ( F2 @ Y )
                      = ( zero_zero @ nat ) ) ) ) ) ) ) ) ).

% sum_eq_1_iff
thf(fact_235_int__one__le__iff__zero__less,axiom,
    ! [Z3: int] :
      ( ( ord_less_eq @ int @ ( one_one @ int ) @ Z3 )
      = ( ord_less @ int @ ( zero_zero @ int ) @ Z3 ) ) ).

% int_one_le_iff_zero_less
thf(fact_236_sum_Oswap,axiom,
    ! [A: $tType,B: $tType,C3: $tType] :
      ( ( comm_monoid_add @ A )
     => ! [G: B > C3 > A,B4: set @ C3,A4: set @ B] :
          ( ( groups1340683514dd_sum @ B @ A
            @ ^ [I: B] : ( groups1340683514dd_sum @ C3 @ A @ ( G @ I ) @ B4 )
            @ A4 )
          = ( groups1340683514dd_sum @ C3 @ A
            @ ^ [J: C3] :
                ( groups1340683514dd_sum @ B @ A
                @ ^ [I: B] : ( G @ I @ J )
                @ A4 )
            @ B4 ) ) ) ).

% sum.swap
thf(fact_237_sum_Onot__neutral__contains__not__neutral,axiom,
    ! [B: $tType,A: $tType] :
      ( ( comm_monoid_add @ A )
     => ! [G: B > A,A4: set @ B] :
          ( ( ( groups1340683514dd_sum @ B @ A @ G @ A4 )
           != ( zero_zero @ A ) )
         => ~ ! [A7: B] :
                ( ( member @ B @ A7 @ A4 )
               => ( ( G @ A7 )
                  = ( zero_zero @ A ) ) ) ) ) ).

% sum.not_neutral_contains_not_neutral
thf(fact_238_sum_Oneutral,axiom,
    ! [B: $tType,A: $tType] :
      ( ( comm_monoid_add @ A )
     => ! [A4: set @ B,G: B > A] :
          ( ! [X4: B] :
              ( ( member @ B @ X4 @ A4 )
             => ( ( G @ X4 )
                = ( zero_zero @ A ) ) )
         => ( ( groups1340683514dd_sum @ B @ A @ G @ A4 )
            = ( zero_zero @ A ) ) ) ) ).

% sum.neutral
thf(fact_239_sum__mono,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ordere216010020id_add @ A )
     => ! [K2: set @ B,F2: B > A,G: B > A] :
          ( ! [I2: B] :
              ( ( member @ B @ I2 @ K2 )
             => ( ord_less_eq @ A @ ( F2 @ I2 ) @ ( G @ I2 ) ) )
         => ( ord_less_eq @ A @ ( groups1340683514dd_sum @ B @ A @ F2 @ K2 ) @ ( groups1340683514dd_sum @ B @ A @ G @ K2 ) ) ) ) ).

% sum_mono
thf(fact_240_sum_Oswap__restrict,axiom,
    ! [A: $tType,B: $tType,C3: $tType] :
      ( ( comm_monoid_add @ A )
     => ! [A4: set @ B,B4: set @ C3,G: B > C3 > A,R: B > C3 > $o] :
          ( ( finite_finite2 @ B @ A4 )
         => ( ( finite_finite2 @ C3 @ B4 )
           => ( ( groups1340683514dd_sum @ B @ A
                @ ^ [X: B] :
                    ( groups1340683514dd_sum @ C3 @ A @ ( G @ X )
                    @ ( collect @ C3
                      @ ^ [Y: C3] :
                          ( ( member @ C3 @ Y @ B4 )
                          & ( R @ X @ Y ) ) ) )
                @ A4 )
              = ( groups1340683514dd_sum @ C3 @ A
                @ ^ [Y: C3] :
                    ( groups1340683514dd_sum @ B @ A
                    @ ^ [X: B] : ( G @ X @ Y )
                    @ ( collect @ B
                      @ ^ [X: B] :
                          ( ( member @ B @ X @ A4 )
                          & ( R @ X @ Y ) ) ) )
                @ B4 ) ) ) ) ) ).

% sum.swap_restrict
thf(fact_241_sum__nonpos,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ordere216010020id_add @ A )
     => ! [A4: set @ B,F2: B > A] :
          ( ! [X4: B] :
              ( ( member @ B @ X4 @ A4 )
             => ( ord_less_eq @ A @ ( F2 @ X4 ) @ ( zero_zero @ A ) ) )
         => ( ord_less_eq @ A @ ( groups1340683514dd_sum @ B @ A @ F2 @ A4 ) @ ( zero_zero @ A ) ) ) ) ).

% sum_nonpos
thf(fact_242_sum__nonneg,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ordere216010020id_add @ A )
     => ! [A4: set @ B,F2: B > A] :
          ( ! [X4: B] :
              ( ( member @ B @ X4 @ A4 )
             => ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( F2 @ X4 ) ) )
         => ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( groups1340683514dd_sum @ B @ A @ F2 @ A4 ) ) ) ) ).

% sum_nonneg
thf(fact_243_sum__mono__inv,axiom,
    ! [A: $tType,I3: $tType] :
      ( ( ordere1818651114id_add @ A )
     => ! [F2: I3 > A,I4: set @ I3,G: I3 > A,I5: I3] :
          ( ( ( groups1340683514dd_sum @ I3 @ A @ F2 @ I4 )
            = ( groups1340683514dd_sum @ I3 @ A @ G @ I4 ) )
         => ( ! [I2: I3] :
                ( ( member @ I3 @ I2 @ I4 )
               => ( ord_less_eq @ A @ ( F2 @ I2 ) @ ( G @ I2 ) ) )
           => ( ( member @ I3 @ I5 @ I4 )
             => ( ( finite_finite2 @ I3 @ I4 )
               => ( ( F2 @ I5 )
                  = ( G @ I5 ) ) ) ) ) ) ) ).

% sum_mono_inv
thf(fact_244_sum_Ointer__filter,axiom,
    ! [A: $tType,B: $tType] :
      ( ( comm_monoid_add @ A )
     => ! [A4: set @ B,G: B > A,P: B > $o] :
          ( ( finite_finite2 @ B @ A4 )
         => ( ( groups1340683514dd_sum @ B @ A @ G
              @ ( collect @ B
                @ ^ [X: B] :
                    ( ( member @ B @ X @ A4 )
                    & ( P @ X ) ) ) )
            = ( groups1340683514dd_sum @ B @ A
              @ ^ [X: B] : ( if @ A @ ( P @ X ) @ ( G @ X ) @ ( zero_zero @ A ) )
              @ A4 ) ) ) ) ).

% sum.inter_filter
thf(fact_245_sum__le__included,axiom,
    ! [B: $tType,A: $tType,C3: $tType] :
      ( ( ordere216010020id_add @ A )
     => ! [S2: set @ B,T2: set @ C3,G: C3 > A,I5: C3 > B,F2: B > A] :
          ( ( finite_finite2 @ B @ S2 )
         => ( ( finite_finite2 @ C3 @ T2 )
           => ( ! [X4: C3] :
                  ( ( member @ C3 @ X4 @ T2 )
                 => ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( G @ X4 ) ) )
             => ( ! [X4: B] :
                    ( ( member @ B @ X4 @ S2 )
                   => ? [Xa: C3] :
                        ( ( member @ C3 @ Xa @ T2 )
                        & ( ( I5 @ Xa )
                          = X4 )
                        & ( ord_less_eq @ A @ ( F2 @ X4 ) @ ( G @ Xa ) ) ) )
               => ( ord_less_eq @ A @ ( groups1340683514dd_sum @ B @ A @ F2 @ S2 ) @ ( groups1340683514dd_sum @ C3 @ A @ G @ T2 ) ) ) ) ) ) ) ).

% sum_le_included
thf(fact_246_sum__nonneg__eq__0__iff,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ordere216010020id_add @ A )
     => ! [A4: set @ B,F2: B > A] :
          ( ( finite_finite2 @ B @ A4 )
         => ( ! [X4: B] :
                ( ( member @ B @ X4 @ A4 )
               => ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( F2 @ X4 ) ) )
           => ( ( ( groups1340683514dd_sum @ B @ A @ F2 @ A4 )
                = ( zero_zero @ A ) )
              = ( ! [X: B] :
                    ( ( member @ B @ X @ A4 )
                   => ( ( F2 @ X )
                      = ( zero_zero @ A ) ) ) ) ) ) ) ) ).

% sum_nonneg_eq_0_iff
thf(fact_247_sum__strict__mono__ex1,axiom,
    ! [A: $tType,I3: $tType] :
      ( ( ordere1818651114id_add @ A )
     => ! [A4: set @ I3,F2: I3 > A,G: I3 > A] :
          ( ( finite_finite2 @ I3 @ A4 )
         => ( ! [X4: I3] :
                ( ( member @ I3 @ X4 @ A4 )
               => ( ord_less_eq @ A @ ( F2 @ X4 ) @ ( G @ X4 ) ) )
           => ( ? [X3: I3] :
                  ( ( member @ I3 @ X3 @ A4 )
                  & ( ord_less @ A @ ( F2 @ X3 ) @ ( G @ X3 ) ) )
             => ( ord_less @ A @ ( groups1340683514dd_sum @ I3 @ A @ F2 @ A4 ) @ ( groups1340683514dd_sum @ I3 @ A @ G @ A4 ) ) ) ) ) ) ).

% sum_strict_mono_ex1
thf(fact_248_sum__nonneg__0,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ordere216010020id_add @ A )
     => ! [S2: set @ B,F2: B > A,I5: B] :
          ( ( finite_finite2 @ B @ S2 )
         => ( ! [I2: B] :
                ( ( member @ B @ I2 @ S2 )
               => ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( F2 @ I2 ) ) )
           => ( ( ( groups1340683514dd_sum @ B @ A @ F2 @ S2 )
                = ( zero_zero @ A ) )
             => ( ( member @ B @ I5 @ S2 )
               => ( ( F2 @ I5 )
                  = ( zero_zero @ A ) ) ) ) ) ) ) ).

% sum_nonneg_0
thf(fact_249_sum__nonneg__leq__bound,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ordere216010020id_add @ A )
     => ! [S2: set @ B,F2: B > A,B4: A,I5: B] :
          ( ( finite_finite2 @ B @ S2 )
         => ( ! [I2: B] :
                ( ( member @ B @ I2 @ S2 )
               => ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( F2 @ I2 ) ) )
           => ( ( ( groups1340683514dd_sum @ B @ A @ F2 @ S2 )
                = B4 )
             => ( ( member @ B @ I5 @ S2 )
               => ( ord_less_eq @ A @ ( F2 @ I5 ) @ B4 ) ) ) ) ) ) ).

% sum_nonneg_leq_bound
thf(fact_250_sum__pos2,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ordere216010020id_add @ A )
     => ! [I4: set @ B,I5: B,F2: B > A] :
          ( ( finite_finite2 @ B @ I4 )
         => ( ( member @ B @ I5 @ I4 )
           => ( ( ord_less @ A @ ( zero_zero @ A ) @ ( F2 @ I5 ) )
             => ( ! [I2: B] :
                    ( ( member @ B @ I2 @ I4 )
                   => ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( F2 @ I2 ) ) )
               => ( ord_less @ A @ ( zero_zero @ A ) @ ( groups1340683514dd_sum @ B @ A @ F2 @ I4 ) ) ) ) ) ) ) ).

% sum_pos2
thf(fact_251_not__one__less__zero,axiom,
    ! [A: $tType] :
      ( ( linord1659791738miring @ A )
     => ~ ( ord_less @ A @ ( one_one @ A ) @ ( zero_zero @ A ) ) ) ).

% not_one_less_zero
thf(fact_252_zero__less__one,axiom,
    ! [A: $tType] :
      ( ( zero_less_one @ A )
     => ( ord_less @ A @ ( zero_zero @ A ) @ ( one_one @ A ) ) ) ).

% zero_less_one
thf(fact_253_linorder__neqE__linordered__idom,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [X2: A,Y2: A] :
          ( ( X2 != Y2 )
         => ( ~ ( ord_less @ A @ X2 @ Y2 )
           => ( ord_less @ A @ Y2 @ X2 ) ) ) ) ).

% linorder_neqE_linordered_idom

% Type constructors (94)
thf(tcon_Polynomial_Opoly___Rings_Oidom,axiom,
    ! [A9: $tType] :
      ( ( idom @ A9 )
     => ( idom @ ( poly @ A9 ) ) ) ).

thf(tcon_Real_Oreal___Rings_Oidom_1,axiom,
    idom @ real ).

thf(tcon_Int_Oint___Rings_Oidom_2,axiom,
    idom @ int ).

thf(tcon_fun___Orderings_Opreorder,axiom,
    ! [A9: $tType,A10: $tType] :
      ( ( preorder @ A10 )
     => ( preorder @ ( A9 > A10 ) ) ) ).

thf(tcon_fun___Finite__Set_Ofinite,axiom,
    ! [A9: $tType,A10: $tType] :
      ( ( ( finite_finite @ A9 )
        & ( finite_finite @ A10 ) )
     => ( finite_finite @ ( A9 > A10 ) ) ) ).

thf(tcon_fun___Orderings_Oorder,axiom,
    ! [A9: $tType,A10: $tType] :
      ( ( order @ A10 )
     => ( order @ ( A9 > A10 ) ) ) ).

thf(tcon_fun___Orderings_Oord,axiom,
    ! [A9: $tType,A10: $tType] :
      ( ( ord @ A10 )
     => ( ord @ ( A9 > A10 ) ) ) ).

thf(tcon_Int_Oint___Conditionally__Complete__Lattices_Oconditionally__complete__linorder,axiom,
    condit1037483654norder @ int ).

thf(tcon_Int_Oint___Groups_Oordered__cancel__comm__monoid__add,axiom,
    ordere1818651114id_add @ int ).

thf(tcon_Int_Oint___Rings_Olinordered__nonzero__semiring,axiom,
    linord1659791738miring @ int ).

thf(tcon_Int_Oint___Groups_Oordered__comm__monoid__add,axiom,
    ordere216010020id_add @ int ).

thf(tcon_Int_Oint___Rings_Oring__no__zero__divisors,axiom,
    ring_n68954251visors @ int ).

thf(tcon_Int_Oint___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add @ int ).

thf(tcon_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom @ int ).

thf(tcon_Int_Oint___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1 @ int ).

thf(tcon_Int_Oint___Rings_Ocomm__semiring__0,axiom,
    comm_semiring_0 @ int ).

thf(tcon_Int_Oint___Rings_Ozero__less__one,axiom,
    zero_less_one @ int ).

thf(tcon_Int_Oint___Orderings_Opreorder_3,axiom,
    preorder @ int ).

thf(tcon_Int_Oint___Orderings_Olinorder,axiom,
    linorder @ int ).

thf(tcon_Int_Oint___Rings_Ocomm__ring__1,axiom,
    comm_ring_1 @ int ).

thf(tcon_Int_Oint___Orderings_Ono__top,axiom,
    no_top @ int ).

thf(tcon_Int_Oint___Orderings_Ono__bot,axiom,
    no_bot @ int ).

thf(tcon_Int_Oint___Orderings_Oorder_4,axiom,
    order @ int ).

thf(tcon_Int_Oint___Nat_Oring__char__0,axiom,
    ring_char_0 @ int ).

thf(tcon_Int_Oint___Orderings_Oord_5,axiom,
    ord @ int ).

thf(tcon_Int_Oint___Groups_Ozero,axiom,
    zero @ int ).

thf(tcon_Int_Oint___Groups_Oone,axiom,
    one @ int ).

thf(tcon_Nat_Onat___Conditionally__Complete__Lattices_Oconditionally__complete__linorder_6,axiom,
    condit1037483654norder @ nat ).

thf(tcon_Nat_Onat___Groups_Oordered__cancel__comm__monoid__add_7,axiom,
    ordere1818651114id_add @ nat ).

thf(tcon_Nat_Onat___Groups_Ocanonically__ordered__monoid__add,axiom,
    canoni770627133id_add @ nat ).

thf(tcon_Nat_Onat___Rings_Olinordered__nonzero__semiring_8,axiom,
    linord1659791738miring @ nat ).

thf(tcon_Nat_Onat___Groups_Oordered__comm__monoid__add_9,axiom,
    ordere216010020id_add @ nat ).

thf(tcon_Nat_Onat___Groups_Ocomm__monoid__add_10,axiom,
    comm_monoid_add @ nat ).

thf(tcon_Nat_Onat___Rings_Ocomm__semiring__1_11,axiom,
    comm_semiring_1 @ nat ).

thf(tcon_Nat_Onat___Rings_Ocomm__semiring__0_12,axiom,
    comm_semiring_0 @ nat ).

thf(tcon_Nat_Onat___Rings_Ozero__less__one_13,axiom,
    zero_less_one @ nat ).

thf(tcon_Nat_Onat___Orderings_Owellorder,axiom,
    wellorder @ nat ).

thf(tcon_Nat_Onat___Orderings_Opreorder_14,axiom,
    preorder @ nat ).

thf(tcon_Nat_Onat___Orderings_Olinorder_15,axiom,
    linorder @ nat ).

thf(tcon_Nat_Onat___Orderings_Ono__top_16,axiom,
    no_top @ nat ).

thf(tcon_Nat_Onat___Orderings_Oorder_17,axiom,
    order @ nat ).

thf(tcon_Nat_Onat___Orderings_Oord_18,axiom,
    ord @ nat ).

thf(tcon_Nat_Onat___Groups_Ozero_19,axiom,
    zero @ nat ).

thf(tcon_Nat_Onat___Groups_Oone_20,axiom,
    one @ nat ).

thf(tcon_Set_Oset___Orderings_Opreorder_21,axiom,
    ! [A9: $tType] : ( preorder @ ( set @ A9 ) ) ).

thf(tcon_Set_Oset___Finite__Set_Ofinite_22,axiom,
    ! [A9: $tType] :
      ( ( finite_finite @ A9 )
     => ( finite_finite @ ( set @ A9 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Oorder_23,axiom,
    ! [A9: $tType] : ( order @ ( set @ A9 ) ) ).

thf(tcon_Set_Oset___Orderings_Oord_24,axiom,
    ! [A9: $tType] : ( ord @ ( set @ A9 ) ) ).

thf(tcon_HOL_Obool___Orderings_Opreorder_25,axiom,
    preorder @ $o ).

thf(tcon_HOL_Obool___Orderings_Olinorder_26,axiom,
    linorder @ $o ).

thf(tcon_HOL_Obool___Finite__Set_Ofinite_27,axiom,
    finite_finite @ $o ).

thf(tcon_HOL_Obool___Orderings_Oorder_28,axiom,
    order @ $o ).

thf(tcon_HOL_Obool___Orderings_Oord_29,axiom,
    ord @ $o ).

thf(tcon_Real_Oreal___Conditionally__Complete__Lattices_Oconditionally__complete__linorder_30,axiom,
    condit1037483654norder @ real ).

thf(tcon_Real_Oreal___Conditionally__Complete__Lattices_Olinear__continuum,axiom,
    condit1656338222tinuum @ real ).

thf(tcon_Real_Oreal___Groups_Oordered__cancel__comm__monoid__add_31,axiom,
    ordere1818651114id_add @ real ).

thf(tcon_Real_Oreal___Rings_Olinordered__nonzero__semiring_32,axiom,
    linord1659791738miring @ real ).

thf(tcon_Real_Oreal___Groups_Oordered__comm__monoid__add_33,axiom,
    ordere216010020id_add @ real ).

thf(tcon_Real_Oreal___Rings_Oring__no__zero__divisors_34,axiom,
    ring_n68954251visors @ real ).

thf(tcon_Real_Oreal___Orderings_Odense__linorder,axiom,
    dense_linorder @ real ).

thf(tcon_Real_Oreal___Fields_Olinordered__field,axiom,
    linordered_field @ real ).

thf(tcon_Real_Oreal___Groups_Ocomm__monoid__add_35,axiom,
    comm_monoid_add @ real ).

thf(tcon_Real_Oreal___Rings_Olinordered__idom_36,axiom,
    linordered_idom @ real ).

thf(tcon_Real_Oreal___Rings_Ocomm__semiring__1_37,axiom,
    comm_semiring_1 @ real ).

thf(tcon_Real_Oreal___Rings_Ocomm__semiring__0_38,axiom,
    comm_semiring_0 @ real ).

thf(tcon_Real_Oreal___Orderings_Odense__order,axiom,
    dense_order @ real ).

thf(tcon_Real_Oreal___Rings_Ozero__less__one_39,axiom,
    zero_less_one @ real ).

thf(tcon_Real_Oreal___Orderings_Opreorder_40,axiom,
    preorder @ real ).

thf(tcon_Real_Oreal___Orderings_Olinorder_41,axiom,
    linorder @ real ).

thf(tcon_Real_Oreal___Rings_Ocomm__ring__1_42,axiom,
    comm_ring_1 @ real ).

thf(tcon_Real_Oreal___Orderings_Ono__top_43,axiom,
    no_top @ real ).

thf(tcon_Real_Oreal___Orderings_Ono__bot_44,axiom,
    no_bot @ real ).

thf(tcon_Real_Oreal___Orderings_Oorder_45,axiom,
    order @ real ).

thf(tcon_Real_Oreal___Nat_Oring__char__0_46,axiom,
    ring_char_0 @ real ).

thf(tcon_Real_Oreal___Orderings_Oord_47,axiom,
    ord @ real ).

thf(tcon_Real_Oreal___Groups_Ozero_48,axiom,
    zero @ real ).

thf(tcon_Real_Oreal___Groups_Oone_49,axiom,
    one @ real ).

thf(tcon_Polynomial_Opoly___Groups_Oordered__cancel__comm__monoid__add_50,axiom,
    ! [A9: $tType] :
      ( ( linordered_idom @ A9 )
     => ( ordere1818651114id_add @ ( poly @ A9 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Olinordered__nonzero__semiring_51,axiom,
    ! [A9: $tType] :
      ( ( linordered_idom @ A9 )
     => ( linord1659791738miring @ ( poly @ A9 ) ) ) ).

thf(tcon_Polynomial_Opoly___Groups_Oordered__comm__monoid__add_52,axiom,
    ! [A9: $tType] :
      ( ( linordered_idom @ A9 )
     => ( ordere216010020id_add @ ( poly @ A9 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Oring__no__zero__divisors_53,axiom,
    ! [A9: $tType] :
      ( ( idom @ A9 )
     => ( ring_n68954251visors @ ( poly @ A9 ) ) ) ).

thf(tcon_Polynomial_Opoly___Groups_Ocomm__monoid__add_54,axiom,
    ! [A9: $tType] :
      ( ( comm_monoid_add @ A9 )
     => ( comm_monoid_add @ ( poly @ A9 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Olinordered__idom_55,axiom,
    ! [A9: $tType] :
      ( ( linordered_idom @ A9 )
     => ( linordered_idom @ ( poly @ A9 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Ocomm__semiring__1_56,axiom,
    ! [A9: $tType] :
      ( ( comm_semiring_1 @ A9 )
     => ( comm_semiring_1 @ ( poly @ A9 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Ocomm__semiring__0_57,axiom,
    ! [A9: $tType] :
      ( ( comm_semiring_0 @ A9 )
     => ( comm_semiring_0 @ ( poly @ A9 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Ozero__less__one_58,axiom,
    ! [A9: $tType] :
      ( ( linordered_idom @ A9 )
     => ( zero_less_one @ ( poly @ A9 ) ) ) ).

thf(tcon_Polynomial_Opoly___Orderings_Opreorder_59,axiom,
    ! [A9: $tType] :
      ( ( linordered_idom @ A9 )
     => ( preorder @ ( poly @ A9 ) ) ) ).

thf(tcon_Polynomial_Opoly___Orderings_Olinorder_60,axiom,
    ! [A9: $tType] :
      ( ( linordered_idom @ A9 )
     => ( linorder @ ( poly @ A9 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Ocomm__ring__1_61,axiom,
    ! [A9: $tType] :
      ( ( comm_ring_1 @ A9 )
     => ( comm_ring_1 @ ( poly @ A9 ) ) ) ).

thf(tcon_Polynomial_Opoly___Orderings_Oorder_62,axiom,
    ! [A9: $tType] :
      ( ( linordered_idom @ A9 )
     => ( order @ ( poly @ A9 ) ) ) ).

thf(tcon_Polynomial_Opoly___Nat_Oring__char__0_63,axiom,
    ! [A9: $tType] :
      ( ( ( ring_char_0 @ A9 )
        & ( comm_ring_1 @ A9 ) )
     => ( ring_char_0 @ ( poly @ A9 ) ) ) ).

thf(tcon_Polynomial_Opoly___Orderings_Oord_64,axiom,
    ! [A9: $tType] :
      ( ( linordered_idom @ A9 )
     => ( ord @ ( poly @ A9 ) ) ) ).

thf(tcon_Polynomial_Opoly___Groups_Ozero_65,axiom,
    ! [A9: $tType] :
      ( ( zero @ A9 )
     => ( zero @ ( poly @ A9 ) ) ) ).

thf(tcon_Polynomial_Opoly___Groups_Oone_66,axiom,
    ! [A9: $tType] :
      ( ( comm_semiring_1 @ A9 )
     => ( one @ ( poly @ A9 ) ) ) ).

% Helper facts (3)
thf(help_If_3_1_T,axiom,
    ! [P: $o] :
      ( ( P = $true )
      | ( P = $false ) ) ).

thf(help_If_2_1_T,axiom,
    ! [A: $tType,X2: A,Y2: A] :
      ( ( if @ A @ $false @ X2 @ Y2 )
      = Y2 ) ).

thf(help_If_1_1_T,axiom,
    ! [A: $tType,X2: A,Y2: A] :
      ( ( if @ A @ $true @ X2 @ Y2 )
      = X2 ) ).

% Conjectures (1)
thf(conj_0,conjecture,
    ( finite_finite2 @ real
    @ ( collect @ real
      @ ^ [X: real] :
          ( ( ( poly2 @ real @ p @ X )
            = ( zero_zero @ real ) )
          & ( ord_less @ real @ a @ X )
          & ( ord_less @ real @ X @ b ) ) ) ) ).

%------------------------------------------------------------------------------
